﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.IO;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakeVisualStudioProject.Converter
{
    public class OptionStringTokenizer
    {
        public static IEnumerable<string> Tokenize(string op)
        {
            using (var reader = new StringReader(op))
            {
                var tokens = new List<string>();
                var tokenBuffer = new StringBuilder();
                var isInnerQuote = false;

                int i = reader.Read();
                while (i != -1)
                {
                    char c = (char)i;
                    i = reader.Read();

                    // TODO: ' (シングルクオート) への対応
                    if (c == '"')
                    {
                        isInnerQuote = !isInnerQuote;
                    }
                    else if (c == ' ')
                    {
                        if (isInnerQuote)
                        {
                            tokenBuffer.Append(c);
                        }
                        else
                        {
                            if (tokenBuffer.Length > 0)
                            {
                                tokens.Add(tokenBuffer.ToString());
                                tokenBuffer.Clear();
                            }
                        }
                    }
                    else
                    {
                        tokenBuffer.Append(c);
                    }
                }
                if (isInnerQuote)
                {
                    throw new ArgumentException("\" の対応関係が取れていません");
                }
                if (tokenBuffer.Length > 0)
                {
                    tokens.Add(tokenBuffer.ToString());
                }

                return tokens;
            }
        }

        public static IEnumerable<string> TokenizeAll(IEnumerable<string> ops)
        {
            return ops.SelectMany(op => Tokenize(op));
        }
    }
}
