﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Microsoft.Build.Construction;
using Nintendo.MakeVisualStudioProject;

namespace Nintendo.MakeSampleSolution
{
    internal class ProjectFile
    {
        private ProjectRootElement m_Project;

        private Guid m_Guid;
        private IEnumerable<ProjectConfiguration> m_ProjectConfigurations;

        public string Path { get; private set; }

        public ProjectFile(string projectPath)
        {
            Path = projectPath;

            m_Project = ProjectRootElement.Open(projectPath);
            m_Guid = Guid.Empty;
        }

        public Guid GetGuid()
        {
            if (m_Guid == Guid.Empty)
            {
                var projectGuidProperty = m_Project.Properties.Where(x => x.Name == "ProjectGuid").FirstOrDefault();
                if (projectGuidProperty == null)
                {
                    throw new ErrorException("プロジェクトファイルから ProjectGuid プロパティを見つけられませんでした。");
                }

                m_Guid = new Guid(projectGuidProperty.Value);
            }
            return m_Guid;
        }

        public IEnumerable<ProjectConfiguration> GetProjectConfigurations()
        {
            if (m_ProjectConfigurations == null)
            {
                var itemGroup = m_Project.ItemGroups.Where(x => x.Label == "ProjectConfigurations").FirstOrDefault();
                if (itemGroup == null)
                {
                    throw new ErrorException("プロジェクトファイルから ProjectConfigurations 設定を見つけられませんでした。");
                }

                var projectConfigurations = itemGroup.Items.Where(x => x.ItemType == "ProjectConfiguration");

                m_ProjectConfigurations = projectConfigurations.Select(x => new ProjectConfiguration(
                    x.Metadata.Single(m => m.Name == "Configuration").Value, x.Metadata.Single(m => m.Name == "Platform").Value));
            }
            return m_ProjectConfigurations;
        }
    }
}
