﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Definition.StaticLibrary
{
    [System.ComponentModel.Composition.Export(typeof(IStaticLibraryDefinition))]
    class wlanapi : IStaticLibraryDefinition
    {
        public string Name => "wlanapi";

        public bool RequestsAddedToAdditionalDependencies(ReleaseIntent intent) =>
            (intent.Spec == Constants.Spec.Generic
                || intent.Spec == Constants.Spec.NX)
            &&
            (intent.Deliverable == Constants.Deliverable.Application
                || intent.Deliverable == Constants.Deliverable.SdkSample
                || intent.Deliverable == Constants.Deliverable.SdkTest);

        public string GetAdditionalDependenciesCondition(ReleaseIntent intent) => Constants.Condition.PlatformWin32OrX64;
    }
}
