﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Definition.StaticLibrary
{
    [System.ComponentModel.Composition.Export(typeof(IStaticLibraryDefinition))]
    class libnn_diagTextPublicJp : IStaticLibraryDefinition
    {
        public string Name => "libnn_diagTextPublicJp";

        public bool RequestsAddedToAdditionalDependencies(ReleaseIntent intent) => true;

        public string GetAdditionalDependenciesCondition(ReleaseIntent intent)
        {
            switch (intent.Spec)
            {
                case Constants.Spec.Generic:
                case Constants.Spec.Cafe:
                    return "'$(LangName)'=='ja-JP'";
                case Constants.Spec.NX:
                    return $"{Constants.Condition.PlatformWin32OrX64} and '$(LangName)'=='ja-JP'";
                default:
                    throw new NotImplementedException();
            }
        }
    }
}
