﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Constructor.Property
{
    [System.ComponentModel.Composition.Export(typeof(ProjectElementConstructor))]
    class OasisPrepareForBuildDependsOn : ProjectElementConstructor
    {
        public override IEnumerable<ProjectElement> Construct(ConstructionContext ctx)
        {
            if (ctx.Intent.Spec != Constants.Spec.NX)
            {
                yield break;
            }

            switch (ctx.Intent.Deliverable)
            {
                case Constants.Deliverable.Sdk:
                case Constants.Deliverable.SdkSample:
                case Constants.Deliverable.SdkTest:
                    // nact で自動生成されたプロジェクトに必要
                    // NX プラットフォームの場合、AfterTargets="PrepareForBuild" ではエラーチェックのタイミングが遅すぎるため、別の手段を使う
                    yield return new ProjectPropertyGroup(Constants.Condition.PlatformNX32OrNX64,
                        new ProjectProperty("OasisPrepareForBuildDependsOn", "NintendoSdkCheckProjectConfigurationValidity;$(OasisPrepareForBuildDependsOn)"));
                    break;
                case Constants.Deliverable.Application:
                    // 不要
                    break;
                default:
                    ReportUnexpectedDeliverable(ctx);
                    break;
            }
        }
    }
}
