﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Constructor.Property
{
    [System.ComponentModel.Composition.Export(typeof(ProjectElementConstructor))]
    class NintendoSdkLibSuffix : ProjectElementConstructor
    {
        public override IEnumerable<ProjectElement> Construct(ConstructionContext ctx)
        {
            yield return new ProjectProperty("NintendoSdkLibSuffix", ".lib", Constants.Condition.PlatformWin32OrX64);

            switch (ctx.Intent.Spec)
            {
                case Constants.Spec.Generic:
                    // 不要
                    break;
                case Constants.Spec.NX:
                    yield return new ProjectProperty("NintendoSdkLibSuffix", ".a", Constants.Condition.PlatformNX32OrNX64);
                    break;
                case Constants.Spec.Cafe:
                    yield return new ProjectProperty("NintendoSdkLibSuffix", ".a", Constants.Condition.PlatformCafe);
                    break;
                default:
                    ReportUnexpectedSpec(ctx);
                    break;
            }
        }
    }
}
