﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Constructor.Property
{
    [System.ComponentModel.Composition.Export(typeof(ProjectElementConstructor))]
    class NintendoSdkIncludePath : ProjectElementConstructor
    {
        public override IEnumerable<ProjectElement> Construct(ConstructionContext ctx)
        {
            var includePaths = new List<string>();

            switch (ctx.Intent.BuildEnvironment)
            {
                case Constants.BuildEnvironment.Repository:
                    switch (ctx.Intent.Deliverable)
                    {
                        case Constants.Deliverable.Sdk:
                            // Alice, Chris, Eris, Iris, NintendoWare によってパスが異なるので、手書きの props で設定する
                            break;
                        default:
                            includePaths.Add(@"$(NintendoSdkRoot)Programs\NintendoWare\Include");
                            includePaths.Add(@"$(NintendoSdkRoot)Programs\NintendoWare\Outputs\Include");
                            includePaths.Add(@"$(NintendoSdkRoot)Programs\Iris\Include");
                            includePaths.Add(@"$(NintendoSdkRoot)Programs\Iris\Outputs\Include");
                            includePaths.Add(@"$(NintendoSdkRoot)Programs\Eris\Include");
                            includePaths.Add(@"$(NintendoSdkRoot)Programs\Eris\Outputs\Include");
                            includePaths.Add(@"$(NintendoSdkRoot)Programs\Chris\Include");
                            includePaths.Add(@"$(NintendoSdkRoot)Programs\Chris\Outputs\Include");
                            includePaths.Add(@"$(NintendoSdkRoot)Programs\Alice\Include");
                            includePaths.Add(@"$(NintendoSdkRoot)Programs\Alice\Outputs\Include");
                            break;
                    }
                    break;
                case Constants.BuildEnvironment.Package:
                    includePaths.Add(@"$(NintendoSdkRoot)Include");
                    break;
                default:
                    ReportUnexpectedBuildEnvironment(ctx);
                    break;
            }

            includePaths.Add(@"$(NintendoSdkRoot)Common\Configs\Targets\$(NintendoSdkBuildTarget)\Include");

            includePaths.Add("$(NintendoSdkIncludePath)");
            yield return new ProjectProperty("NintendoSdkIncludePath", string.Join(";", includePaths));
        }
    }
}
