﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Constructor.Property
{
    [System.ComponentModel.Composition.Export(typeof(ProjectElementConstructor))]
    class ExtensionsToDeleteOnClean : ProjectElementConstructor
    {
        public override IEnumerable<ProjectElement> Construct(ConstructionContext ctx)
        {
            switch (ctx.Intent.BuildEnvironment)
            {
                case Constants.BuildEnvironment.Repository:
                    // .iobj, .ipdb ファイルが Clean で削除されない場合がある問題への対策
                    yield return new ProjectPropertyGroup(Constants.Condition.PlatformWin32OrX64,
                        new ProjectProperty("ExtensionsToDeleteOnClean",
                            "$(ExtensionsToDeleteOnClean);$(OutDir)$(TargetName).iobj;$(OutDir)$(TargetName).ipdb",
                            Constants.Condition.ConfigurationTypeApplicationOrDynamicLibrary));
                    break;
                case Constants.BuildEnvironment.Package:
                    // 不要？
                    break;
                default:
                    ReportUnexpectedBuildEnvironment(ctx);
                    break;
            }
        }
    }
}
