﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Constructor.ItemDefinition.Link
{
    [System.ComponentModel.Composition.Export(typeof(ProjectElementConstructor))]
    class AdditionalOptions : ProjectElementConstructor
    {
        public override IEnumerable<ProjectElement> Construct(ConstructionContext ctx)
        {
            switch (ctx.Intent.Spec)
            {
                case Constants.Spec.Generic:
                    return Enumerable.Empty<ProjectElement>();
                case Constants.Spec.NX:
                    return ConstructNXOptions(ctx);
                case Constants.Spec.Cafe:
                    return ConstructCafeOptions(ctx);
                default:
                    ReportUnexpectedSpec(ctx);
                    return Enumerable.Empty<ProjectElement>();
            }
        }

        private IEnumerable<ProjectElement> ConstructNXOptions(ConstructionContext ctx)
        {
            yield return new ProjectItemDefinition(
                "Link",
                $"{Constants.Condition.ConfigurationTypeApplication} and {Constants.Condition.NintendoSdkProgramKindApplication}",
                    new ProjectMetadata(
                        "AdditionalOptions",
                        "-Wl,-u,malloc -Wl,-u,calloc -Wl,-u,realloc -Wl,-u,aligned_alloc -Wl,-u,free %(AdditionalOptions)",
                        Constants.Condition.PlatformNX32OrNX64));

            if (ctx.Intent.PublishSystemProgramSettings)
            {
                yield return new ProjectItemDefinition(
                    "Link",
                    $"{Constants.Condition.ConfigurationTypeApplication} and {Constants.Condition.NintendoSdkProgramKindApplicationWithoutSdkNso}",
                        new ProjectMetadata(
                            "AdditionalOptions",
                            "-Wl,-u,malloc -Wl,-u,calloc -Wl,-u,realloc -Wl,-u,aligned_alloc -Wl,-u,free %(AdditionalOptions)",
                            Constants.Condition.PlatformNX32OrNX64));
            }
        }

        private IEnumerable<ProjectElement> ConstructCafeOptions(ConstructionContext ctx)
        {
            yield return new ProjectItemDefinition("Link", Constants.Condition.PlatformCafe,
                new ProjectMetadata("AdditionalOptions", "-relprog_cafe %(AdditionalOptions)"));
        }
    }
}
