﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Constructor.ItemDefinition.Link
{
    [System.ComponentModel.Composition.Export(typeof(ProjectElementConstructor))]
    class AdditionalNSODependencies : ProjectElementConstructor
    {
        private static readonly string[] s_ApplicationNsos = new string[0];

        public override IEnumerable<ProjectElement> Construct(ConstructionContext ctx)
        {
            if (ctx.Intent.Spec != Constants.Spec.NX)
            {
                yield break;
            }

            var metadatas = new List<ProjectMetadata>();

            switch (ctx.Intent.Deliverable)
            {
                case Constants.Deliverable.Sdk:
                case Constants.Deliverable.SdkTest:
                    // 不要
                    break;
                case Constants.Deliverable.SdkSample:
                case Constants.Deliverable.Application:
                    metadatas.Add(new ProjectMetadata("AdditionalNSODependencies",
                        string.Join(";", s_ApplicationNsos.Select(x => $"{x}$(NintendoSdkDllSuffix)").Concat(new[] { "%(AdditionalNSODependencies)" })),
                        Constants.Condition.ConfigurationTypeApplication));
                    break;
                default:
                    ReportUnexpectedDeliverable(ctx);
                    break;
            }

            if (ctx.Intent.PublishSystemProgramSettings)
            {
                metadatas.Add(new ProjectMetadata("AdditionalNSODependencies",
                    string.Empty,
                    $"{Constants.Condition.ConfigurationTypeApplication} and {Constants.Condition.NintendoSdkProgramKindSystemProgramOrApplicationWithoutSdkNso}"));
            }

            yield return new ProjectItemDefinition("Link", Constants.Condition.PlatformNX32OrNX64, metadatas.ToArray());
        }
    }
}
