﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Constructor.ItemDefinition.ClCompile
{
    [System.ComponentModel.Composition.Export(typeof(ProjectElementConstructor))]
    class Optimization : ProjectElementConstructor
    {
        public override IEnumerable<ProjectElement> Construct(ConstructionContext ctx)
        {
            yield return new ProjectItemDefinition("ClCompile", $"{Constants.Condition.PlatformWin32OrX64} and {Constants.Condition.PlatformToolsetUseCl}",
                new ProjectMetadata("Optimization", "Disabled", Constants.Condition.NintendoSdkBuildTypeDebug),
                new ProjectMetadata("Optimization", "MaxSpeed", Constants.Condition.NintendoSdkBuildTypeDevelopOrRelease));

            yield return new ProjectItemDefinition("ClCompile", $"{Constants.Condition.PlatformWin32OrX64} and {Constants.Condition.PlatformToolsetUseClang}",
                new ProjectMetadata("Optimization", "Disabled", Constants.Condition.NintendoSdkBuildTypeDebug),
                new ProjectMetadata("Optimization", "Full", Constants.Condition.NintendoSdkBuildTypeDevelopOrRelease));
        }
    }
}
