﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Constructor.ItemDefinition.ClCompile
{
    [System.ComponentModel.Composition.Export(typeof(ProjectElementConstructor))]
    class DiagnosticsFormat : ProjectElementConstructor
    {
        public override IEnumerable<ProjectElement> Construct(ConstructionContext ctx)
        {
            switch (ctx.Intent.Deliverable)
            {
                case Constants.Deliverable.Sdk:
                case Constants.Deliverable.SdkSample:
                case Constants.Deliverable.SdkTest:
                    yield return new ProjectItemDefinition("ClCompile", $"{Constants.Condition.PlatformWin32OrX64} and {Constants.Condition.PlatformToolsetUseCl}",
                        new ProjectMetadata("DiagnosticsFormat", "Caret", "'$(PlatformToolset)'=='v141'"));
                    break;
                case Constants.Deliverable.Application:
                    // 警告含むコンパイル結果には影響しないので、SDK のヘッダファイルはいずれの DiagnosticsFormat でコンパイルされてもよい。アプリ開発者の方針にゆだねる。
                    break;
                default:
                    ReportUnexpectedDeliverable(ctx);
                    break;
            }
        }
    }
}
