﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Constants
{
    public static class Condition
    {
        public const string PlatformWin32 = "'$(Platform)'=='Win32'";
        public const string PlatformX64 = "'$(Platform)'=='x64'";
        public const string PlatformWin32OrX64 = "('$(Platform)'=='Win32' or '$(Platform)'=='x64')";
        public const string PlatformNX32 = "'$(Platform)'=='NX32'";
        public const string PlatformNX64 = "'$(Platform)'=='NX64'";
        public const string PlatformNX32OrNX64 = "('$(Platform)'=='NX32' or '$(Platform)'=='NX64')";
        public const string PlatformCafe = "'$(Platform)'=='Cafe'";

        public const string ConfigurationTypeStaticLibrary = "'$(ConfigurationType)'=='StaticLibrary'";
        public const string ConfigurationTypeDynamicLibrary = "'$(ConfigurationType)'=='DynamicLibrary'";
        public const string ConfigurationTypeApplication = "'$(ConfigurationType)'=='Application'";
        public const string ConfigurationTypeLibrary = "('$(ConfigurationType)'=='StaticLibrary' or '$(ConfigurationType)'=='DynamicLibrary')";
        public const string ConfigurationTypeApplicationOrDynamicLibrary = "('$(ConfigurationType)'=='Application' or '$(ConfigurationType)'=='DynamicLibrary')";

        public const string NintendoSdkBuildTypeDebug = "'$(NintendoSdkBuildType)'=='Debug'";
        public const string NintendoSdkBuildTypeDevelop = "'$(NintendoSdkBuildType)'=='Develop'";
        public const string NintendoSdkBuildTypeRelease = "'$(NintendoSdkBuildType)'=='Release'";
        public const string NintendoSdkBuildTypeDebugOrDevelop = "('$(NintendoSdkBuildType)'=='Debug' or '$(NintendoSdkBuildType)'=='Develop')";
        public const string NintendoSdkBuildTypeDevelopOrRelease = "('$(NintendoSdkBuildType)'=='Develop' or '$(NintendoSdkBuildType)'=='Release')";

        public const string NintendoSdkProgramKindApplication = "'$(_NintendoSdkProgramKind)'=='Application'";
        public const string NintendoSdkProgramKindApplicationWithoutSdkNso = "'$(_NintendoSdkProgramKind)'=='ApplicationWithoutSdkNso'";
        public const string NintendoSdkProgramKindSystemProgram = "'$(_NintendoSdkProgramKind)'=='SystemProgram'";
        public const string NintendoSdkProgramKindApplicationOrApplicationWithoutSdkNso = "('$(_NintendoSdkProgramKind)'=='Application' or '$(_NintendoSdkProgramKind)'=='ApplicationWithoutSdkNso')";
        public const string NintendoSdkProgramKindSystemProgramOrApplicationWithoutSdkNso = "('$(_NintendoSdkProgramKind)'=='SystemProgram' or '$(_NintendoSdkProgramKind)'=='ApplicationWithoutSdkNso')";

        public const string PlatformToolsetUseCl = "'$(PlatformToolset.EndsWith(_clang_c2))'!='true'";
        public const string PlatformToolsetUseClang = "'$(PlatformToolset.EndsWith(_clang_c2))'=='true'";
    }
}
