﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Nintendo.Foundation.IO;

namespace Nintendo.MakePropertySheets
{
    internal class CommandLineOption
    {
        [CommandLineValue(
            0,
            Description = "出力先プロパティシートのパス",
            IsRequired = true,
            ValueName = "outpath")]
        public string OutputPath { get; private set; }

        [CommandLineOption(
            "build-environment",
            Description = "プロパティシートが対象とするビルド環境")]
        public string BuildEnvironment { get; private set; }

        [CommandLineOption(
            "spec",
            Description = "プロパティシートが対象とするスペック")]
        public string Spec { get; private set; }

        [CommandLineOption(
            "deliverable",
            Description = "プロパティシートが対象とするビルド成果物")]
        public string Deliverable { get; private set; }

        [CommandLineOption(
            "system-program",
            DefaultValue = false,
            Description = "プログラム種別 SystemProgram, ApplicationWithoutSdkNso のビルド設定を出力するか否か")]
        public bool PublishSystemProgramSettings { get; private set; }

        public static CommandLineOption Parse(string[] args)
        {
            var parser = new CommandLineParser();

            CommandLineOption option;
            var continues = parser.ParseArgs(args, out option);

            if (continues)
            {
                return option;
            }
            else
            {
                return null;
            }
        }
    }
}
