﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace MakeBuildRules
{
    internal class Program
    {
        static int Main(string[] args)
        {
            if (args.Length < 1)
            {
                Console.Error.WriteLine("MakeBuildRules <SigloRoot>");
                return 1;
            }

            var sigloRoot = args[0];

            // パスが不正な形式であれば存在しないことになる
            if (!Directory.Exists(sigloRoot))
            {
                Console.Error.WriteLine($"{sigloRoot} not found.");
                return 1;
            }

            try
            {
                BuildRuleMaker.Execute(sigloRoot);
            }
            catch (Exception e) when (e is IOException || e is UnauthorizedAccessException)
            {
                Console.Error.WriteLine(e.Message);
                Console.Error.WriteLine(e.StackTrace);
                return 1;
            }

            return 0;
        }
    }
}
