﻿using Microsoft.Win32;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace LocateVSIXInstaller
{
    internal static class RegistryUtil
    {
        /// <summary>
        /// レジストリ値を、以下のキーから取得します。最初に見つかった値を返します。見つからなければ null を返します。
        ///
        /// * $"HKLM:SOFTWARE\{relativePathToKey}"
        /// * $"HKCU:SOFTWARE\{relativePathToKey}"
        /// * $"HKLM:SOFTWARE\Wow6432Node\{relativePathToKey}"
        /// * $"HKCU:SOFTWARE\Wow6432Node\{relativePathToKey}"
        /// </summary>
        public static object GetSoftwareValue(string relativePathToKey, string valueName)
        {
            return
                GetValue(Registry.LocalMachine, @"SOFTWARE\" + relativePathToKey, valueName)
                ?? GetValue(Registry.CurrentUser, @"SOFTWARE\" + relativePathToKey, valueName)
                ?? GetValue(Registry.LocalMachine, @"SOFTWARE\Wow6432Node\" + relativePathToKey, valueName)
                ?? GetValue(Registry.CurrentUser, @"SOFTWARE\Wow6432Node\" + relativePathToKey, valueName);
        }

        public static object GetValue(RegistryKey baseKey, string subKeyName, string valueName)
        {
            using (var subKey = baseKey.OpenSubKey(subKeyName))
            {
                return subKey?.GetValue(valueName);
            }
        }
    }
}
