﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "stdafx.h"
#include "TreeWalker.h"

namespace Libgit2 {

    TreeWalker::TreeWalker(git_repository* repository, std::vector<TreeEntryNative>* entries)
        : m_pRepository(repository), m_pTreeEntries(entries)
    {
    }

    int TreeWalker::TreeWalkFunction(const char *root, const git_tree_entry *entry, void *payload)
    {
        TreeWalker *walker = (TreeWalker*)(payload);

        git_otype type = git_tree_entry_type(entry);
        if(GIT_OBJ_BLOB == type)
        {
            TreeEntryNative entryNative;

            ObjectHolder object;
            int error = git_tree_entry_to_object(object.GetPointer(), walker->m_pRepository, entry);
            if(error != 0)
            {
                return error;
            }

            const git_blob* blob = reinterpret_cast<const git_blob*>(object.GetHandle());

            git_off_t rawsize = git_blob_rawsize(blob);
            std::string filename(git_tree_entry_name(entry));

            entryNative.size = rawsize;
            entryNative.filename = root + filename;

            walker->m_pTreeEntries->push_back(entryNative);
        }

        return 0;
    }
}
