﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using GitExternalStorage.Consoles;
using GitExternalStorage.Core;
using GitExternalStorage.Transports;

namespace GitExternalStorage.Commands
{
    /// <summary>
    /// git の update-index --assume-unchanged 相当の操作を行うコマンドです。
    /// </summary>
    public class AssumeUnchangedCommand : CommandBase
    {
        public AssumeUnchangedCommand()
            : base()
        {
        }

        public AssumeUnchangedCommand(CommandConsoleBase console)
            : base(console)
        {
        }

        public override void Run()
        {
            this.AssumeUnchanged();
        }

        /// <summary>
        /// 管理対象ファイルをすべて --assume-unchanged にします。
        /// </summary>
        private void AssumeUnchanged()
        {
            CommandConsole.WriteLineToOut("Set files to 'assume-unchanged'.");
            var referenceInfo = Reference.FindReferences(Environments.GitRepository);

            if (referenceInfo.All.Count() > 0)
            {
                Environments.GitRepositoryLibgit2.SetAssumeUnchanged(referenceInfo.All.Select(x => x.FilePath).ToList(), true);
            }

            CommandConsole.WriteLineToOut("Complete!");
        }
    }
}
