﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using GitExternalRepository.Repository.Git;

namespace GitExternalRepository.Configs
{
    /// <summary>
    /// 現在有効な外部リポジトリを示すリストを扱うクラスです。
    /// </summary>
    public class ActiveRepositoryListGitConfig : EntryListGitConfig<ActiveRepositoryListEntry>
    {
        /// <summary>
        /// 指定の git config ファイルをリポジトリリストとして扱います。
        /// </summary>
        /// <param name="filepath">コンフィグファイルへのパス</param>
        public ActiveRepositoryListGitConfig(string filepath)
            : base(filepath, "exrepo", SubSectionType.Required)
        {
        }
    }
}
