﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdio>
#include <nn/nn_SdkLog.h>
#include <nn/util/util_FormatString.h>

extern "C" {

int xmlSNPrintf(char *str, size_t count, const char *fmt, ...)
{
    va_list arg;
    va_start(arg, fmt);
    int ret = nn::util::VSNPrintf(str, count, fmt, arg);
    va_end(arg);
    return ret;
}

int xmlVSNPrintf(char *str, size_t count, const char *fmt, va_list arg)
{
    return nn::util::VSNPrintf(str, count, fmt, arg);
}

int xmlVFPrintf(FILE*, const char *fmt, va_list arg)
{
    NN_SDK_VLOG(fmt, arg);
    return 0;
}

int xmlFPrintf(FILE* fp, const char *fmt, ...)
{
    va_list arg;
    va_start(arg, fmt);
    int ret = xmlVFPrintf(fp, fmt, arg);
    va_end(arg);
    return ret;
}

}
