﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/util/util_BinaryFormat.h>
#include <nn/util/util_ResDic.h>
#include <nn/util/util_ResEndian.h>

namespace nn { namespace util {

void SwapEndian( ResEndian* pCtx, ResDic* pRes ) NN_NOEXCEPT
{
    struct Impl
    {
        static void SwapSelf( ResDicData* pData )
        {
            SwapEndian( &pData->count );
        }

        static void SwapChild( ResEndian* /*pCtx*/, ResDicData* pData )
        {
            for ( int idxEntry = 0, numEntry = 1 + pData->count; idxEntry < numEntry; ++idxEntry )
            {
                ResDicData::Entry& entry = pData->entries[ idxEntry ];
                SwapEndian( &entry.refBit );
                SwapEndian( &entry.children[ 0 ] );
                SwapEndian( &entry.children[ 1 ] );
            }
        }
    };

    ResDicData* ptr = &pRes->ToData();

    if ( pCtx->IsHostEndian() )
    {
        Impl::SwapChild( pCtx, ptr );
        Impl::SwapSelf( ptr );
    }
    else
    {
        Impl::SwapSelf( ptr );
        Impl::SwapChild( pCtx, ptr );
    }
}

void SwapEndian( ResEndian* pCtx, StringPool* pRes ) NN_NOEXCEPT
{
    // 構造体内のメンバはリトルエンディアン固定のため反転の必要はありません。

    // StringPool の _strings が示す先頭は空文字を示す BinString で、
    // _stringCount は空文字を除いた BinString の数です。
    pCtx->SwapStrings( pRes->_strings.GetNext(), pRes->GetStringCount() );
}

}} // namespace nn/util
