﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "edid_Serialize.h"

// For multi-byte values, LSB is stored in first location
// Check Section 3.2 in EDID spec

namespace nn { namespace edid { namespace detail {

    template <>
    std::uint16_t Serialize<std::uint16_t>(const std::uint8_t* pData) NN_NOEXCEPT
    {
        return (pData[1] << 8) | pData[0];
    }

    template <>
    std::uint32_t Serialize<std::uint32_t>(const std::uint8_t* pData) NN_NOEXCEPT
    {
        return (pData[3] << 24) | (pData[2] << 16) | (pData[1] << 8) | pData[0];
    }

}}}
