﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdio>
#include <nn/diag/detail/diag_DetailLog.h>

namespace nn { namespace diag {

/**
*   @brief      ログのメタ情報です。
*
*   @deprecated 廃止予定です。代わりに LogMetaData を使用してください。
*/
struct LogMetaInfo
{
    const char* fileName;       //!<    ソースコードのファイル名
    int lineNumber;             //!<    ソースコード内での行番号
};

namespace detail {

void VLogImpl(const LogMetaInfo& logMetaInfo, const char* format, std::va_list formatArg) NN_NOEXCEPT
{
    NN_UNUSED(logMetaInfo);
    std::vprintf(format, formatArg);
}

void LogImpl(const LogMetaInfo& logMetaInfo, const char* format, ...) NN_NOEXCEPT
{
    std::va_list list;
    va_start(list, format);
    VLogImpl(logMetaInfo, format, list);
    va_end(list);
}

void VLogImpl(const LogMetaData& logMetaData, const char* format, std::va_list formatArg) NN_NOEXCEPT
{
    NN_UNUSED(logMetaData);
    std::vprintf(format, formatArg);
}

void LogImpl(const LogMetaData& logMetaData, const char* format, ...) NN_NOEXCEPT
{
    std::va_list list;
    va_start(list, format);
    VLogImpl(logMetaData, format, list);
    va_end(list);
}

void PutImpl(const LogMetaData& logMetaData, const char* text, size_t length) NN_NOEXCEPT
{
    NN_UNUSED(logMetaData);
    std::fwrite(text, sizeof(char), length, stdout);
}

} // detail

}} // nn::diag
