﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdarg>
#include <cstdlib>
#include <nn/nn_Abort.h>
#include <nn/diag/diag_AbortTypes.h>
#include <nn/diag/diag_AssertionTypes.h>
#include <nn/diag/diag_LogTypes.h>

namespace nn { namespace diag { namespace detail {

void PrintAbortInfo(const AbortInfo &abortInfo) NN_NOEXCEPT;

namespace {
    AbortReason ToAbortReason(
        AssertionType assertionType) NN_NOEXCEPT
    {
        switch( assertionType )
        {
        case AssertionType_SdkAssert:
            return AbortReason_SdkAssert;
        case AssertionType_SdkRequires:
            return AbortReason_SdkRequires;
        case AssertionType_UserAssert:
            return AbortReason_UserAssert;
        default:
            return AbortReason_Abort;
        }
    }
} // anonymous

void OnAssertionFailure(
    AssertionType assertionType,
    const char* condition,
    const char* functionName,
    const char* fileName,
    int lineNumber,
    const char* format,
    ...) NN_NOEXCEPT
{
    std::va_list list;
    va_start(list, format);

    const nn::diag::LogMessage message = {format, &list};
    const AbortInfo abortInfo = {
        ToAbortReason(assertionType),
        &message,
        condition,
        functionName,
        fileName,
        lineNumber
    };
    PrintAbortInfo(abortInfo);

    va_end(list);
    std::abort();
}

void OnAssertionFailure(
    AssertionType assertionType,
    const char* condition,
    const char* functionName,
    const char* fileName,
    int lineNumber) NN_NOEXCEPT
{
    OnAssertionFailure(
        assertionType,
        condition,
        functionName,
        fileName,
        lineNumber,
        "");
}

}}} // nn::diag::detail
