﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/cstd/cstd_Config.h>

#if !NN_BUILD_CONFIG_COMPILER_SUPPORTS_GHS
    #error  "GHS MULTI コンパイラーが利用出来るビルド条件ではありません。"
#endif

#include <math.h>   // NOLINT : C++03 の cmath は isnan/isinf を含まないので、math.h を使用する
#include <nn/cstd/cstd_CMath.h>

namespace nn { namespace cstd {

bool IsNan(long double value) NN_NOEXCEPT
{
    return isnan(value) != 0;
}

bool IsNan(double value) NN_NOEXCEPT
{
    return isnan(value) != 0;
}

bool IsNan(float value) NN_NOEXCEPT
{
    return isnan(value) != 0;
}

bool IsInf(long double value) NN_NOEXCEPT
{
    return isinf(value) != 0;
}

bool IsInf(double value) NN_NOEXCEPT
{
    return isinf(value) != 0;
}

bool IsInf(float value) NN_NOEXCEPT
{
    return isinf(value) != 0;
}

}}
