﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/crypto.h>

#define WIN32_NO_STATUS
#include <nn/nn_Windows.h>
#undef WIN32_NO_STATUS

#include <ntstatus.h>
#include <bcrypt.h>

#pragma comment(lib,"bcrypt.lib")


namespace nn { namespace crypto {

    void GenerateCryptographicallyRandomBytes(
        void*   pOutBuffer,
        size_t  bufferSize ) NN_NOEXCEPT
    {
        NTSTATUS status = BCryptGenRandom(
            NULL,
            static_cast<PUCHAR>(pOutBuffer),
            static_cast<ULONG>(bufferSize),
            BCRYPT_USE_SYSTEM_PREFERRED_RNG );

        NN_ABORT_UNLESS( status == STATUS_SUCCESS );
    }

}}  // namespace nn::crypto
