﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/crypto/crypto_Sha1Generator.h>

namespace nn { namespace crypto {

const uint8_t Sha1Generator::Asn1ObjectIdentifier[Asn1ObjectIdentifierSize] = {
    0x30, 0x21, 0x30, 0x09, 0x06, 0x05, 0x2b, 0x0e, 0x03, 0x02, 0x1a, 0x05, 0x00, 0x04, 0x14
};

void GenerateSha1Hash(void* pHash, size_t hashSize, const void* pData, size_t dataSize) NN_NOEXCEPT
{
    Sha1Generator sha1;

    sha1.Initialize();
    sha1.Update(pData, dataSize);
    sha1.GetHash(pHash, hashSize);
}

}} // namespace nn::crypto
