﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/crypto/crypto_Aes128CtrDecryptor.h>

namespace nn { namespace crypto {

size_t DecryptAes128Ctr(void* pDst, size_t dstSize,
                        const void* pKey, size_t keySize,
                        const void* pIv, size_t ivSize,
                        const void* pSrc, size_t srcSize) NN_NOEXCEPT
{
    Aes128CtrDecryptor aes128ctr;

    aes128ctr.Initialize(pKey, keySize, pIv, ivSize);
    return aes128ctr.Update(pDst, dstSize, pSrc, srcSize);
}

}}
