﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>


param
(
    [string]
    $VersionXmlPath,

    [string]
    $Identifier,

    [string]
    $PropertySheetPath
)

trap
{
    Write-Error -ErrorRecord $_
    exit 1
}

Set-StrictMode -Version Latest

function Create-SimplePropertySheet
{
    param
    (
        [Parameter(Mandatory = $true)]
        [hashtable[]]
        $Properties
    )

    $props = [xml] @"
<Project ToolsVersion="4.0" xmlns="http://schemas.microsoft.com/developer/msbuild/2003">
    <PropertyGroup />
</Project>
"@

    $Properties | % {
        $e = $props.CreateElement($_["Name"], "http://schemas.microsoft.com/developer/msbuild/2003")
        $e.InnerText = $_["Value"]
        $props["Project"]["PropertyGroup"].AppendChild($e) | Out-Null
    }

    return $props
}

function Save-PropertySheet
{
    param
    (
        [Parameter(Mandatory = $true)]
        [xml]
        $PropertySheet,

        [Parameter(Mandatory = $true)]
        [string]
        $Path
    )

    $xmlWriterSettings = New-Object System.Xml.XmlWriterSettings
    $xmlWriterSettings.Indent = $true

    $xmlWriter = [System.Xml.XmlWriter]::Create($Path, $xmlWriterSettings)

    $PropertySheet.Save($xmlWriter)
}

$xml = [xml] (Get-Content $VersionXmlPath)

$properties = @(
    @{ "Name" = "NintendoSdk$($Identifier)VersionMajor"; "Value" = $xml.Product.Version.Major },
    @{ "Name" = "NintendoSdk$($Identifier)VersionMinor"; "Value" = $xml.Product.Version.Minor },
    @{ "Name" = "NintendoSdk$($Identifier)VersionMicro"; "Value" = $xml.Product.Version.Micro },
    @{ "Name" = "NintendoSdk$($Identifier)VersionReleaseStep"; "Value" = $xml.Product.Version.Relstep }
)

$props = Create-SimplePropertySheet $properties

Save-PropertySheet -PropertySheet $props -Path $PropertySheetPath
