﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief Defines for sync levels.
 */

#pragma once

namespace nn { namespace edid {

    /**
     * @brief Analog sync levels.
     *
     * @details The signal level standard ratio is documented as
     *          Video : Sync : Total
     */
    enum SyncLevel
    {
        SyncLevel_Digital, //!< Signal uses digital sync.
        SyncLevel_300,     //!< 0.700 : 0.300 : 1.000 V p-p
        SyncLevel_286,     //!< 0.714 : 0.286 : 1.000 V p-p
        SyncLevel_400,     //!< 1.000 : 0.400 : 1.400 V p-p
        SyncLevel_000,     //!< 0.700 : 0.000 : 0.700 V p-p
    };

}}
