﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief Defines for stereoscopic 3D.
 */

#pragma once

namespace nn { namespace edid {

    /**
     * @brief 3D stereoscopic modes for displays.
     */
    enum StereoMode
    {
        StereoMode_None,                 //!< Standard 2D display mode.
        StereoMode_FramePacking,         //!< 3D implemented with frame packing.
        StereoMode_TopAndBottom,         //!< 3D implemented with top and bottom.
        StereoMode_SideBySide,           //!< 3D implemented with side by side.
        StereoMode_FieldSequentialRight, //!< Field sequential stereo with right image when stereo sync is high.
        StereoMode_FieldSequentialLeft,  //!< Field sequential stereo with left image when stereo sync is high.
        StereoMode_InterleavedRight,     //!< Two way interleaved stereo with right image on even lines.
        StereoMode_InterleavedLeft,      //!< Two way interleaved stereo with left image on even lines.
        StereoMode_Interleaved,          //!< Four way interleaved stereo.
    };

}}
