﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief Defines for color depth.
 */

#pragma once

namespace nn { namespace edid {

    /**
     * @brief Color bit depth supported by the display.
     *
     * @details Color bit depth is only really defined for digital signals.
     */
    enum ColorDepth
    {
        ColorDepth_6Bits,     //!< Uses 6 bits per primary color.
        ColorDepth_8Bits,     //!< Uses 8 bits per primary color.
        ColorDepth_10Bits,    //!< Uses 10 bits per primary color.
        ColorDepth_12Bits,    //!< Uses 12 bits per primary color.
        ColorDepth_14Bits,    //!< Uses 14 bits per primary color.
        ColorDepth_16Bits,    //!< Uses 16 bits per primary color.
        ColorDepth_Undefined, //!< Color bit depth is undefined.
    };

}}
