﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief Defines for audio format codes.
 */

#pragma once

namespace nn { namespace edid {

    /**
     * @brief Audio format codes available in the EDID.
     */
    enum AudioFormat
    {
        AudioFormat_Pcm,          //!< PCM format.
        AudioFormat_Ac3,          //!< AC3 format.
        AudioFormat_Mpeg1,        //!< MPEG-1 format.
        AudioFormat_Mp3,          //!< MP3 format.
        AudioFormat_Mpeg2,        //!< MPEG2 format.
        AudioFormat_AacLc,        //!< AAC LC format.
        AudioFormat_Dts,          //!< DTS format.
        AudioFormat_Atrac,        //!< ATRAC format.
        AudioFormat_Dsd,          //!< DSD format.
        AudioFormat_EAc3,         //!< E-AC-3 format.
        AudioFormat_DtsHd,        //!< DTS-HD format.
        AudioFormat_Mlp,          //!< MLP format.
        AudioFormat_Dst,          //!< DST format.
        AudioFormat_WmaPro,       //!< WMA Pro format.
        AudioFormat_HeAac,        //!< HE-AAC format.
        AudioFormat_HeAacV2,      //!< HE-AACv2 format.
        AudioFormat_MpegSurround, //!< MPEG Surround format.
    };

}}
