﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
* @file
* @brief   Abortマクロ 関係の型定義
*/

#include <nn/nn_Common.h>
#include <nn/diag/diag_AbortTypes.h>
#include <nn/os/os_UserExceptionHandlerTypes.h>

namespace nn { namespace diag {

/**
*   @brief      アボートオブザーバに与えられる、アボートに関する情報です。
*/
struct SdkAbortInfo
{
    AbortInfo abortInfo;
    Result result;
    const nn::os::UserExceptionInfo* userExceptionInfo;
};

}} // nn::diag
