﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/crypto/detail/crypto_EcdsaImpl.h>
#include <nn/crypto/detail/crypto_EccP256Key.h>

namespace nn { namespace crypto {

template <typename HashFunction>
class EcdsaP256Verifier
{
public:
    static const size_t SignatureSize = detail::EccP256Key::PublicKeySize;
    static const size_t PrivateKeySize = detail::EccP256Key::PrivateKeySize;
    static const size_t RandomSize = detail::EccP256Key::PrivateKeySize;

    bool Verify(const void* pSignature, size_t signatureSize,
                const void* publicKeyOctets, size_t publicKeySize,
                const void* rawMessage, size_t rawMessageSize) NN_NOEXCEPT
    {
        return m_Impl.Verify( pSignature, signatureSize, publicKeyOctets, publicKeySize,
                              rawMessage, rawMessageSize );
    }

private:
    detail::EcdsaImpl<detail::EccP256Key,HashFunction> m_Impl;
};

NN_DEFINE_STATIC_CONSTANT(template<typename T> const size_t EcdsaP256Verifier<T>::SignatureSize);
NN_DEFINE_STATIC_CONSTANT(template<typename T> const size_t EcdsaP256Verifier<T>::PrivateKeySize);
NN_DEFINE_STATIC_CONSTANT(template<typename T> const size_t EcdsaP256Verifier<T>::RandomSize);

}} // namespace nn::crypto
