﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/crypto/crypto_EcdsaP256Signer.h>
#include <nn/crypto/crypto_Sha256Generator.h>

namespace nn { namespace crypto {

typedef EcdsaP256Signer<nn::crypto::Sha256Generator> EcdsaP256Sha256Signer;

inline void SignEcdsaP256Sha256( void* outSignature, size_t signatureSize,
                                 const void* privateKeyOctets, size_t privateKeySize,
                                 const void* rawMessage, size_t rawMessageSize,
                                 const void* random, size_t randomSize) NN_NOEXCEPT
{
    EcdsaP256Sha256Signer auth;
    auth.Sign( outSignature, signatureSize, privateKeyOctets, privateKeySize,
               rawMessage, rawMessageSize, random, randomSize );
}

}} // namespace nn::crypto
