﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Nintendo.ToolFoundation.IO;

namespace ZarfCreator
{
    public class ZarfCreatorParam
    {
        private string RootPath;
        [CommandLineOption(
            "root",
            IsRequired = true,
            DefaultValue = null,
            Description = "SDK のルートディレクトリを指定します。\n")]
        public string SdkRoot
        {
            get
            {
                return RootPath;
            }
            private set
            {
                // 必ず区切り文字で終わるように
                RootPath = Path.GetFullPath(
                                    value.EndsWith(Path.DirectorySeparatorChar.ToString()) ?
                                    value : value + Path.DirectorySeparatorChar);
            }
        }

        private string OutputDirPath;
        [CommandLineOption(
            "output-dir",
            IsRequired = false,
            DefaultValue = null,
            Description = "Zarf ファイルの出力先を指定します。\n"
                + "省略した場合、--root で指定したディレクトリに出力します。\n")]
        public string OutputPath
        {
            get
            {
                return string.IsNullOrWhiteSpace(OutputDirPath) ? SdkRoot : OutputDirPath;
            }
            private set
            {
                if (string.IsNullOrWhiteSpace(value))
                {
                    OutputDirPath = SdkRoot;
                }
                else
                {
                    // 必ず区切り文字で終わるように
                    OutputDirPath = Path.GetFullPath(
                                        value.EndsWith(Path.DirectorySeparatorChar.ToString()) ?
                                        value : value + Path.DirectorySeparatorChar);
                }
            }
        }

        [CommandLineOption(
            "source-file",
            IsRequired = true,
            DefaultValue = null,
            Description = "作成したい Zarf 定義ファイルを指定します。\n")]
        public string SourceZarfDefinitionPath { get; private set; }

        [CommandLineOption(
            "archive-path",
            IsRequired = true,
            DefaultValue = null,
            Description = "Zarf に含むアーカイブを指定します。複数回指定が可能です。\n")]
        public string[] SourceArchivePaths { get; private set; }

        [CommandLineOption(
            "snapshot-version",
            DefaultValue = "",
            Description = "スナップショットとして Zarf を作成する場合に追加で付与するスナップショットバージョンです。",
            IsRequired = false)]
        public string SnapShotVersion { get; private set; }

        [CommandLineOption(
            "contents-locale",
            DefaultValue = null,
            Description = "パッケージの中身のロケールです。",
            IsRequired = false)]
        public string ContentsLocale { get; private set; }
    }
}
