﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using ZarfCreator.ZarfDefinitionData;

namespace ZarfCreator.Parser
{
    internal class DashboardDetailsParser
    {
        /// <summary>
        /// セットアップコマンドのパースを行います
        /// </summary>
        /// <param name="source">コマンドリスト</param>
        /// <returns>パース結果</returns>
        internal DashboardDetailsInfo Parse(Dictionary<string, object> source)
        {
            var dashboardDetails = new DashboardDetailsInfo();

            foreach (var key in source.Keys)
            {
                try
                {
                    switch (key)
                    {
                    case DashboardDetailsElement.GroupName:
                        dashboardDetails.GroupName = (string)source[key];
                        break;
                    case DashboardDetailsElement.GroupDisplayName:
                        dashboardDetails.GroupDisplayName = TextInfoParser.Parse((Dictionary<string, object>)source[key]);
                        break;
                    case DashboardDetailsElement.Icon:
                        dashboardDetails.Icon = (string)source[key];
                        break;
                    case DashboardDetailsElement.DisplayText:
                        dashboardDetails.DisplayText = TextInfoParser.Parse((Dictionary<string, object>)source[key]);
                        break;

                    default:
                        throw new FormatException("Unknown key has specified.");
                    }
                }
                catch (Exception)
                {
                    Console.Error.WriteLine("ERROR: Error has occured at '{0}'. ", key);
                    throw;
                }
            }

            string error;
            if (!dashboardDetails.Validate(out error))
            {
                Console.Error.WriteLine(error);

                throw new FormatException("Required items have not been completed.");
            }

            return dashboardDetails;
        }

        private static class DashboardDetailsElement
        {
            public const string GroupName = "GroupName";
            public const string GroupDisplayName = "GroupDisplayName";
            public const string Icon = "Icon" ;
            public const string DisplayText = "DisplayText";
        }
    }
}
