﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace TestRunner.GenerationRule
{
    using Executer;

    /// <summary>
    /// exe ファイル用のインストラクション生成ルールです。
    /// </summary>
    internal sealed class ExeFileRule : InstructionGenerator.IRule
    {
        /// <summary>
        /// サポート対象のテストコンテキストかどうかを示す値を取得します。
        /// </summary>
        /// <param name="context">テストコンテキストです。</param>
        /// <returns>サポート対象のテストコンテキストかどうかを示す値です。</returns>
        public bool Supports(TestContext context)
        {
            return context.TargetPath.EndsWith(".exe");
        }

        /// <summary>
        /// ルール適用時にターゲットファイルを必要とするかどうかを示す値を取得します。
        /// </summary>
        /// <returns>ルール適用時にターゲットファイルを必要とするかどうかを示す値です。</returns>
        public bool NeedsTargetFile()
        {
            return false;
        }

        /// <summary>
        /// テストコンテキストにインストラクション生成ルールを適用します。
        /// </summary>
        /// <param name="context">テストコンテキストです。</param>
        /// <returns>生成されたテストインストラクションです。</returns>
        public InstructionGenerator.Instruction Generate(TestContext context)
        {
            var inst = new InstructionGenerator.Instruction();

            inst.Command = context.TargetPath;

            inst.Option = context.Option;

            inst.Platform = string.IsNullOrEmpty(context.Platform)
                ? BuildSystem.DefaultPlatform
                : context.Platform;

            inst.BuildType = string.IsNullOrEmpty(context.BuildType)
                ? BuildSystem.DefaultBuildType
                : context.BuildType;

            inst.TargetPath = context.TargetPath;

            inst.TargetProjectPath = context.TargetProjectPath;

            inst.ReportPath = context.ReportPath;

            inst.DumpFileType = DumpFileTypeDefinition.MiniDump;

            inst.DumpFilePath = Utility.RemoveExtension(
                context.Path, ExtensionDefinition.TestResult
                ) + DumpFileExtensionDefinition.MiniDump;

            return inst;
        }
    }
}
