﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace TestRunner.Executer
{
    /// <summary>
    /// テストリストコンテキストです。
    /// </summary>
    public sealed class ListContext
    {
        /// <summary>
        /// テスト結果ファイルの絶対パスを取得または設定します。
        /// </summary>
        public string Path { get; set; }

        /// <summary>
        /// テストリスト名を取得または設定します。
        /// </summary>
        public string ListName { get; set; }

        /// <summary>
        /// テストリスト ID を取得または設定します。
        /// </summary>
        public uint ListId { get; set; }

        /// <summary>
        /// テストリストに含まれるテストステートメントの総数を取得または設定します。
        /// </summary>
        public uint StatementCount { get; set; }

        /// <summary>
        /// テストステートメント ID を取得または設定します。
        /// </summary>
        public uint StatementId { get; set; }

        /// <summary>
        /// 指定されたプラットフォームの総数を取得または設定します。
        /// </summary>
        public uint PlatformCount { get; set; }

        /// <summary>
        /// プラットフォーム ID を取得または設定します。
        /// </summary>
        public uint PlatformId { get; set; }

        /// <summary>
        /// プラットフォーム名を取得または設定します。
        /// </summary>
        public string PlatformName { get; set; }

        /// <summary>
        /// 指定されたビルドタイプの総数を取得または設定します。
        /// </summary>
        public uint BuildTypeCount { get; set; }

        /// <summary>
        /// ビルドタイプ ID を取得または設定します。
        /// </summary>
        public uint BuildTypeId { get; set; }

        /// <summary>
        /// ビルドタイプ名を取得または設定します。
        /// </summary>
        public string BuildTypeName { get; set; }

        /// <summary>
        /// 結果識別コードを取得または設定します。
        /// </summary>
        public ResultCode ResultCode { get; set; }

        /// <summary>
        /// エラーメッセージを取得または設定します。
        /// </summary>
        public string ErrorMessage { get; set; }

        /// <summary>
        /// シャローコピーを取得します。
        /// </summary>
        /// <returns>シャローコピーです。</returns>
        public ListContext Clone()
        {
            return (ListContext)this.MemberwiseClone();
        }
    }
}
