﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace TestRunner.Executer.InsertionRule
{
    using System;
    using System.Linq;
    using System.Xml;

    /// <summary>
    /// GoogleTest 用のテスト対象名埋め込みルールです。
    /// </summary>
    public sealed class GoogleTestXmlRule : TargetNameInserter.IRule
    {
        public const string Extention = ".test_detail.xml";

        /// <summary>
        /// サポート対象となるテスト詳細ファイルの拡張子を取得します。
        /// </summary>
        /// <returns>サポート対象となるテスト詳細ファイルの拡張子です。</returns>
        public string GetExtention()
        {
            return Extention;
        }

        /// <summary>
        /// サポート対象となるテスト詳細ファイルかどうかを示す値を取得します。
        /// </summary>
        /// <param name="path">テスト詳細ファイルのパスです。</param>
        /// <returns>サポート対象となるテスト詳細ファイルかどうかを示す値です。</returns>
        public bool Supports(string path)
        {
            return path.EndsWith(Extention);
        }

        /// <summary>
        /// テスト詳細ファイルにテスト対象名を埋め込みます。
        /// </summary>
        /// <param name="dstPath">結果の出力先パスです。</param>
        /// <param name="srcPath">テスト詳細ファイルのパスです。</param>
        /// <param name="targetName">テスト対象名です。</param>
        public void Insert(string dstPath, string srcPath, string targetName)
        {
            var document = new XmlDocument();

            document.Load(srcPath);

            TargetNameInserter.InsertIntoXml(document.DocumentElement, targetName, GetValidAttribute);

            document.Save(dstPath);
        }

        private static XmlNode GetValidAttribute(XmlNode node)
        {
            if (node.Name == "testcase")
            {
                return node.Attributes.GetNamedItem("classname");
            }

            if (node.Name == "testsuite")
            {
                return node.Attributes.GetNamedItem("name");
            }

            return null;
        }
    }
}
