﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace SystemUpdaterNx.Uninstall
{
    using System;
    using Properties;
    using TargetShell.CommandPluginBase;
    using TargetShell.Library;
    using TargetShell.PluginInterface;

    /// <summary>
    /// アンイントールプラグインの定数定義
    /// </summary>
    public class Constants
    {
        /// <summary>
        /// サブコマンド uninstall の文字列
        /// <summary>
        public const string SubCommand = "uninstall";
        /// <summary>
        /// オプション all-uninstall の文字列
        /// <summary>
        public const string OptionAllUninstall = "all-uninstall";
        /// <summary>
        /// オプション application-id の文字列
        /// <summary>
        public const string OptionApplicationId = "application-id";
        /// <summary>
        /// オプション index の文字列
        /// <summary>
        public const string OptionIndex = "index";
        /// <summary>
        /// オプション type の文字列
        /// <summary>
        public const string OptionType = "type";
    }

    /// <summary>
    /// サブコマンドのオプション引数
    /// </summary>
    public class SubCommandArgument : BaseCommand<CommandParameter>, ISubCommandArgument
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public SubCommandArgument()
        {
            this.SubCommandName = Constants.SubCommand;
        }

        /// <summary>
        /// コマンドラインパーサにコマンドを登録します。
        /// </summary>
        /// <param name="commandLineParser">コマンドラインパーサです。</param>
        public void RegisterWith(CommandLineParser commandLineParser)
        {
            // サブコマンド
            var subcommand = commandLineParser.ActionCommand
                .AddCommand(Constants.SubCommand);
            subcommand
                .GetBuilder()
                .SetDescription(SetupTargetResources.UninstallDescription);

            // 共通オプション
            this.OptionArgs.CommonArgs.RegisterWith(subcommand);

            // サブコマンド固有のオプション
            subcommand
                .AddValueOption(Constants.OptionType,
                        new Action<string>(x => this.DevicePluginArgs.Type = x))
                .GetBuilder()
                .SetDescription(SetupTargetResources.UninstallDescriptioType);
            subcommand
                .AddValueOption(Constants.OptionApplicationId,
                        new Action<string>(x => this.DevicePluginArgs.ApplicationId = x))
                .GetBuilder()
                .SetDescription(SetupTargetResources.UninstallDescriptionApplicationId);
            subcommand
                .AddFlagOption(Constants.OptionAllUninstall,
                        new Action(() => this.DevicePluginArgs.AllUninstall = true))
                .GetBuilder()
                .SetDescription(SetupTargetResources.UninstallDescriptioAllUninstall);
            subcommand
                .AddValueOption(Constants.OptionIndex,
                        new Action<string>(x => this.DevicePluginArgs.Index = x))
                .GetBuilder()
                .SetDescription(SetupTargetResources.UninstallDescriptioIndex);
        }
    }
}
