﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace SystemUpdaterNx.GetSaveDataList
{
    using Properties;
    using TargetShell.CommandPluginBase;
    using TargetShell.Library;
    using TargetShell.PluginInterface;

    /// <summary>
    /// サブコマンド定義
    /// </summary>
    public class Constants
    {
        /// <summary>
        /// サブコマンドの文字列
        /// <summary>
        public const string SubCommand = "get-savedata-list";
        /// <summary>
        /// 出力結果タイトル
        /// <summary>
        public const string OutputTitleString = "Savedata List Result";
        /// <summary>
        /// 1行結果の修飾文字列
        /// <summary>
        public const string OutputOneLinePrefix = "Savedata List";
    }

    /// <summary>
    /// サブコマンドのオプション引数
    /// </summary>
    public class SubCommandArgument : BaseCommand<CommandParameter>, ISubCommandArgument
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public SubCommandArgument()
        {
            this.SubCommandName = Constants.SubCommand;
            this.OptionArgs.DevicePluginArgs.OutputTitleString = Constants.OutputTitleString;
            this.OptionArgs.DevicePluginArgs.OutputOneLinePrefix = Constants.OutputOneLinePrefix;
        }

        /// <summary>
        /// コマンドラインパーサにコマンドを登録します。
        /// </summary>
        /// <param name="commandLineParser">コマンドラインパーサです。</param>
        public void RegisterWith(CommandLineParser commandLineParser)
        {
            // サブコマンド
            var subcommand = commandLineParser.ActionCommand
                .AddCommand(Constants.SubCommand);
            subcommand
                .GetBuilder()
                .SetDescription(GetTargetInfoResources.GetSavedataListDescription);

            // 共通オプション
            this.OptionArgs.CommonArgs.RegisterWith(subcommand);

            // サブコマンド固有のオプション
            // なし
        }
    }
}
