﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace SystemUpdaterNx.SetBatteryLevel.Command
{
    using Nintendo.ToolFoundation.CommandLine;
    using Properties;
    using TargetShell.CommandPluginBase;
    using TargetShell.Library;
    using TargetShell.PluginInterface;

    /// <summary>
    /// プラグインの定数定義
    /// </summary>
    public class Constants
    {
        /// <summary>
        /// サブコマンド set-battery-level の文字列
        /// <summary>
        public const string SubCommand = "set-battery-level";
        /// <summary>
        /// オプション hold-time の文字列
        /// <summary>
        public const string BatteryLevel = "battery-level";
    }

    /// <summary>
    /// サブコマンドのオプション引数
    /// </summary>
    public class SubCommandArgument : BaseCommand<CommandParameter>, ISubCommandArgument
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public SubCommandArgument()
        {
            this.SubCommandName = Constants.SubCommand;
        }

        /// <summary>
        /// コマンドラインパーサにコマンドを登録します。
        /// </summary>
        /// <param name="command">アクションコマンド</param>
        public void RegisterWith(ActionCommand command)
        {
            var commandparameter = TargetShellLibrary.CastParameter<CommandParameter>(
                    this.OptionArgs.DevicePluginArgs);
            // サブコマンド
            var subcommand = command
                .AddCommand(Constants.SubCommand);
            subcommand
                .GetBuilder()
                .SetDescription(ControlSdevPowerSupplyResources.SetBatteryLevelDescription);

            // 共通オプション
            this.OptionArgs.CommonArgs.RegisterWith(subcommand);

            // サブコマンド固有のオプション
            subcommand
                .AddValueOption(Constants.BatteryLevel,
                    x => commandparameter.BatteryLevel = x)
                .GetBuilder()
                .SetDescription(
                        ControlSdevPowerSupplyResources.SetBatteryLevelDescriptionBatteryLevel)
                .Require();
        }
    }
}
