﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace PrivateNx.WriteBootConfig
{
    using TargetShell.CommandPluginBase;

    /// <summary>
    /// BootConfig書き換えをする時のパラメータ
    /// </summary>
    public class CommandParameter : BaseCommandParameter
    {
        /// <summary>
        /// キータイプ
        /// </summary>
        public string KeyType { get; set; }

        /// <summary>
        /// 署名付きOS/署名なしOS
        /// </summary>
        public string SignedType { get; set; }

        /// <summary>
        /// BootConfigの書き換え対象を切り替えます。
        ///     設定なし：下記の1箇所に対して書き換えを行います。
        ///                 ・Normal Main BootConfig
        ///     設定あり：下記の4箇所に対して書き換えを行います。
        ///                 ・Normal Main BootConfig
        ///                 ・Normal Sub BootConfig
        ///                 ・SefeMode Main BootConfig
        ///                 ・SefeMode Sub BootConfig
        /// </summary>
        public bool AllBootConfig { get; set; }
    }
}
