﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace TargetShell.CommandPluginBase
{
    using System.Collections.Generic;
    using TargetShell.PluginInterface;

    /// <summary>
    /// デバイスプラグインの共通インターフェース
    /// </summary>
    public interface IDevicePluginInterface<CommandParameter>
    {
        /// <summary>
        /// デバイスの情報を取得する
        /// </summary>
        /// <returns>デバイスの情報</returns>
        List<DevicePluginInfo> GetDeviceInfo();
        /// <summary>
        /// デバイスプラグインを実行する
        /// </summary>
        /// <param name="deviceList">デバイスリスト</param>
        /// <param name="parameter">コマンドパラメータ</param>
        /// <returns>処理成功の数</returns>
        int RunDevicePlugin(List<TargetEntry> deviceList, CommandParameter parameter);
    }
}
