﻿#----------------------------------------------------------------
function Add-HeaderPart( [ref]$L, $SubPackageName )
{
    if ( $English )
    {
        $L.value += @'
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html lang="en-US">
<head>
<meta charset="utf-8" />
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
<script type="text/javascript" src="../template/js/common/manualLib.js"></script>
<script type="text/javascript" src="../tocData.js"></script>
<link rel="stylesheet" type="text/css" href="../template/css/template.css" />
<link rel="stylesheet" type="text/css" href="../template/css/releasenote.css" />
<title>{0} ChangeLog</title>
</head>

<body data-reassemble="autoindex=no,forceNoLabel=yes">
<div id="autoindex_content">
<div class="body_content">
<noscript>
<div style="border: 4 double black; margin: 4px; padding: 2px; font-weight: bold; background-color: FFFFCC;">
<p>Some features in this documentation are unavailable because JavaScript is not enabled in your browser. </p>
<p>The table of contents is available only if JavaScript is enabled. <br />Enable JavaScript and reload this page. <br /><br /></p>
</div>
</noscript>

<div class="breadcrumb">
<a href="../ChangeLog.html">Change Log</a> &gt; {0} Change Log
</div>
'@ -f $SubPackageName
    }
    else
    {
        $L.value += @'
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html lang="ja">
<head>
<meta charset="utf-8" />
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
<script type="text/javascript" src="../template/js/common/manualLib.js"></script>
<script type="text/javascript" src="../tocData.js"></script>
<link rel="stylesheet" type="text/css" href="../template/css/template.css" />
<link rel="stylesheet" type="text/css" href="../template/css/releasenote.css" />
<title>{0} 変更履歴</title>
</head>

<body data-reassemble="autoindex=no,forceNoLabel=yes">
<div id="autoindex_content">
<div class="body_content">
<noscript>
<div style="border: 4 double black; margin: 4px; padding: 2px; font-weight: bold; background-color: FFFFCC;">
<p>お使いのブラウザは JavaScript が使用できないため、本ドキュメントの一部機能が無効になっています。</p>
<p>JavaScript が無効の環境では目次を使用することができません。<br />JavaScriptの実行が許可された状態で閲覧してください。<br /><br /></p>
</div>
</noscript>

<div class="breadcrumb">
<a href="../ChangeLog.html">変更履歴</a> &gt; {0} 変更履歴
</div>
'@ -f $SubPackageName
    }
}

#--------------------------------------------------------------------------------
function Add-LegendPart ([ref]$L )
{
    if ( $English )
    {
        $L.value += @'
<h2>Legends</h2>
<table>
    <tr><td class="release_note"><span class="nocomp_style"></span></td><td>Specification change that breaks your code</td><td><span class="release_note"><span class="mini_nocomp_style"></span></span></td></tr>
    <tr><td class="release_note"><span class="addition_style"></span></td><td>Added Features</td><td><span class="release_note"><span class="mini_addition_style"></span></span></td></tr>
    <tr><td class="release_note"><span class="improvement_style"></span></td><td>Improvements</td><td><span class="release_note"><span class="mini_improvement_style"></span></span></td></tr>
    <tr><td class="release_note"><span class="bugfix_style"></span></td><td>Bug Fixes</td><td><span class="release_note"><span class="mini_bugfix_style"></span></span></td></tr>
</table>
'@
    }
    else
    {
        $L.value += @'
<h2>凡例</h2>
<table>
    <tr><td class="release_note"><span class="nocomp_style"></span></td><td>互換性の失われる仕様変更</td><td><span class="release_note"><span class="mini_nocomp_style"></span></span></td></tr>
    <tr><td class="release_note"><span class="addition_style"></span></td><td>機能追加</td><td><span class="release_note"><span class="mini_addition_style"></span></span></td></tr>
    <tr><td class="release_note"><span class="improvement_style"></span></td><td>改善</td><td><span class="release_note"><span class="mini_improvement_style"></span></span></td></tr>
    <tr><td class="release_note"><span class="bugfix_style"></span></td><td>不具合修正</td><td><span class="release_note"><span class="mini_bugfix_style"></span></span></td></tr>
</table>
'@
    }
}

#--------------------------------------------------------------------------------
function Add-PageTitle( [ref]$L, $title, $mainName )
{
    if ( $English )
    {
        $L.value += @'

<!-- ====================================================================== -->
<div class="pagetitle">{0} Change Log </div>
<div class="text_separate">

<p>Click <a href="../ChangeLog.html">here</a> to go back to the top of change log. </p>
<p>For the previous revision history entries, see <a href="{2}">here</a>. </p>
<br>
<p>(-> <a href="{1}">Display by version</a>)</p>

</div>

<h1 id="contents">Contents </h1>

'@  -f $title, $mainName, ($mainName -replace ".html","_old.html")
    }
    else
    {
        $L.value += @'

<!-- ====================================================================== -->
<div class="pagetitle">{0} 変更履歴</div>
<div class="text_separate">

<p>変更履歴トップへは<a href="../ChangeLog.html">こちら</a>から戻ります。</p>
<p>過去の変更履歴は<a href="{2}">こちら</a>です。</p>
<br>
<p>(→ <a href="{1}">通常のバージョン別表示</a>)</p>

</div>

<h1 id="contents">目次</h1>

'@  -f $title, $mainName, ($mainName -replace ".html","_old.html")
    }
}

#--------------------------------------------------------------------------------
function Add-HeadingComponent( [ref]$L )
{
    if ( $English )
    {
        $L.value += "<h3 id=`"componentList`">Category list</h3>"
    }
    else
    {
        $L.value += "<h3 id=`"componentList`">機能一覧</h3>"
    }
}

#--------------------------------------------------------------------------------
function Add-HeadingVersion( [ref]$L )
{
    if ( $English )
    {
        $L.value += "<h3>Version list</h3>"
    }
    else
    {
        $L.value += "<h3>対象バージョン</h3>"
    }
}

#--------------------------------------------------------------------------------
function Add-NoChange( [ref]$L )
{
    if ( $English )
    {
        $L.value += "<br><br><p>No change.</p><br><br>"
    }
    else
    {
        $L.value += "<br><br><p>変更はありません。</p><br><br>"
    }
}

#--------------------------------------------------------------------------------
function Add-FooterPart( [ref]$L )
{
    if ( $English )
    {
        $L.value += @'
    <!-- ====================================================================== -->
    <div id="rn_footer">
      <div class="confidential_logo">
      Confidential
      </div>
      <div class="confidential_en">
      This document contains confidential and proprietary information of Nintendo and is also protected under the copyright laws of the United States and foreign countries. No part of this document may be released, distributed, transmitted, or reproduced in any form or by any electronic or mechanical means, including information storage and retrieval systems, without permission in writing from Nintendo.
      </div>
      <div class="copyright">
        Copyright (C)2017 Nintendo/HAL Laboratory, Inc. All rights reserved. <br />
      All company and product names in this document are the trademarks or registered trademarks of their respective companies.
      </div>
    </div>

    <br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br>
</div>
</div>
</body>
</html>
'@
    }
    else
    {
        $L.value += @'
    <!-- ====================================================================== -->
    <div id="rn_footer">
      <div class="confidential_logo">
        "Confidential"
      </div>
      <div class="confidential_en">
        This document contains confidential and proprietary information of Nintendo
        and is also protected under the copyright laws of the United States and foreign countries.
        No part of this document may be released, distributed, transmitted or reproduced
        in any form or by any electronic or mechanical means,
        including information storage and retrieval systems,
        without permission in writing from Nintendo.
      </div>
      <div class="confidential_ja">
        このドキュメントの内容は、秘密情報であるため、厳重な取扱い、管理を行なってください。
      </div>
      <div class="copyright">
        Copyright (C)2017 Nintendo/HAL Laboratory, Inc. All rights reserved. <br />
        記載されている会社名、製品名等は、各社の登録商標または商標です。
      </div>
    </div>

    <br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br>
</div>
</div>
</body>
</html>
'@
    }
}

#--------------------------------------------------------------------------------
function Link-SrcComponent( [ref]$L, $component, $len )
{
    # ハッシュ作成
    $md5 = [System.Security.Cryptography.MD5]::Create()
    $hash0 = $md5.ComputeHash( [System.Text.Encoding]::UTF8.GetBytes( $component ) )
    $hash = [System.BitConverter]::ToString($hash0).ToLower().Replace("-","")

    $L.value += ( "<nobr><a href=`"#$hash`">{0}</a><small>({1})</small></nobr>" -f $component, $len )
}

#--------------------------------------------------------------------------------
function Create-CsvList( $AllCsv, $name, $mainName, $indexPlist, $PackageName, $SubPackageName )
{
    $IsUseCompList = $false
    if ( $ComponentCategoryFile -ne "" -and $ComponentCategoryFile -ne $null )
    {
        if ( Test-Path -path $ComponentCategoryFile)
        {
            $IsUseCompList = $true
            [Xml]$CatList = Get-Content -Encoding UTF8 $ComponentCategoryFile
        }
    }

    [string[]]$private:HList = @() #ヘッダ用
    Add-HeaderPart ([ref]$HList) $SubPackageName
    Add-PageTitle ([ref]$HList) $SubPackageName $mainName

    $versionColor="#ffa0ff"
    $versionPre=""

    $AllCsv0 = [array]( $AllCsv | where { $_.PACKAGENUM -eq $indexPlist } )

    while($true)
    {
        if ( $AllCsv0 -eq $null -or $AllCsv0.Length -eq "0" )
        {
            Add-NoChange ([ref]$HList)
            break
        }

        # 存在するバージョン
        $ComponentArray = [array]( $AllCsv0 | sort COMPONENT_CAT,COMPONENT_JA | Foreach-object { $_.COMPONENT } | unique )
        $VersionNumArray = [array]( $AllCsv0 | Foreach-object { $_.VERSIONNUM } | sort | unique )
        [array]$ComponentListArray = @()

        #---- コンポーネント一覧
        Add-HeadingComponent ([ref]$HList)
        $HList += "<p>"
        if ( ! $IsUseCompList )
        {
            $i = 0
            foreach( $component in $ComponentArray )
            {
                $i ++
                if ( $component -eq "" -or $component -eq $null )
                {
                    continue
                }

                # ハッシュ作成
                $md5 = [System.Security.Cryptography.MD5]::Create()
                $hash0 = $md5.ComputeHash( [System.Text.Encoding]::UTF8.GetBytes( $component ) )
                $hash = [System.BitConverter]::ToString($hash0).ToLower().Replace("-","")

                $PartCsv = [array]( $AllCsv0 | where { $_.COMPONENT -eq $component } )
                $bar = $( if ( $i -eq $ComponentArray.Length ){ "" }else{ " | " })
                $HList += ( " <nobr><a href=`"#$hash`">{0}</a><small>({1})</small>{2}</nobr>" -f $component, $PartCsv.Length, $bar )

                $ComponentListArray += $component
            }
        }
        else
        {
            [string[]]$OtherComponent = $ComponentArray
            $n = 0
            $HList += "<table>"
            if ( $English )
            {
                $HList += "<tr><th>Category</th><th>Function name</th></tr>"
            }
            else
            {
                $HList += "<tr><th>カテゴリ</th><th>機能名</th></tr>"
            }
            while( $n -lt ([Array]$CatList.CategoryList.Category).Length )
            {
                $trFlag = $false
                $m = 0
                while( $m -lt ([Array]([Array]$CatList.CategoryList.Category)[$n].Component).Length )
                {
                    $c = ([Array]([Array]$CatList.CategoryList.Category)[$n].Component)[$m]

                    # そのコンポーネントが使われているか
                    $PartCsv = [array]( $AllCsv0 | where { $_.COMPONENT -eq $c } )
                    if ( $PartCsv.Length -gt 0 )
                    {
                        if ( ! $trFlag )
                        {
                            $HList += ("<tr><td>{0}</td><td>" -f ([Array]$CatList.CategoryList.Category)[$n].name)
                            $trFlag = $true
                        }
                        Link-SrcComponent ([ref]$HList) $c $PartCsv.Length
                        $ComponentListArray += $c

                        # OtherComponent から取り去る
                        $nc = 0
                        while( $nc -lt $OtherComponent.Length )
                        {
                            if ( $OtherComponent[$nc] -eq $c )
                            {
                                $OtherComponent[$nc] = ""
                            }
                            $nc ++
                        }
                    }

                    $m ++
                }
                if ( $trFlag )
                {
                    $HList += "</td></tr>"
                }
                $n ++
            }

            $trFlag = $false
            foreach( $component in $OtherComponent )
            {
                if ( $component -ne "" )
                {
                    if ( ! $trFlag )
                    {
                        if ( $English )
                        {
                            $HList += "<tr><td>Other</td><td>"
                        }
                        else
                        {
                            $HList += "<tr><td>その他</td><td>"
                        }
                        $trFlag = $true
                    }
                    $PartCsv = [array]( $AllCsv0 | where { $_.COMPONENT -eq $component } )
                    Link-SrcComponent ([ref]$HList) $component $PartCsv.Length
                    $ComponentListArray += $component
                }
            }
            if ( $trFlag )
            {
                $HList += "</td></tr>"
            }

            $HList += "</table>"
        }
        $HList += "</p>"

        #---- 対象バージョン
        Add-HeadingVersion ([ref]$HList)
        $HList += "<p>"
        foreach( $vernum in $VersionNumArray )
        {
            # 文字列 (vernum は 0,1,2... それを文字列に)
            $PartCsv = [array]( $AllCsv0 | where { $_.VERSIONNUM -eq $vernum } )
            $HList += "<nobr>" + $PartCsv[0].VERSION + "</nobr><br>"
        }
        $HList += "</p>"

        Add-LegendPart ([ref]$HList)

        [string[]]$private:IList = @() #一覧用
        [string[]]$private:CList = @() #本体用

        #---- 内容本体
        foreach( $component in $ComponentListArray )
        {
            # ハッシュ作成
            $md5 = [System.Security.Cryptography.MD5]::Create()
            $hash0 = $md5.ComputeHash( [System.Text.Encoding]::UTF8.GetBytes( $component ) )
            $hash = [System.BitConverter]::ToString($hash0).ToLower().Replace("-","")

            $PartCsv = [array]( $AllCsv0 | where { $_.COMPONENT -eq $component } )

            $IList += "<h2 id=`"{2}`"><a href=`"#content_{2}`">{0}</a> ({1}) <a href=`"#componentList`"><font size=`"2`">&lt</font></a></h2>" -f $component, $PartCsv.Length, $hash
            $IList += "<br>"
            $CList += "<h1 id=`"content_{2}`">{0} ({1}) <a href=`"#{2}`"><font size=`"2`">&lt</font></a></h1>`r`n" -f $component, $PartCsv.Length, $hash

            # 一覧つくるため
            $preVerStr = ""
            $listIn = $false

            $n = 0
            foreach( $vernum in $VersionNumArray )
            {
                $PartCsv2 = [array]( $PartCsv | where { $_.VERSIONNUM -eq $vernum } )
                foreach( $ct in @(0, 1, 2, 3) )
                {
                    $PartCsv3 = [array]( $PartCsv2 | where { $_.CATEGORY -eq $ct } )

                    foreach( $prio in @(3, 2, 1) )
                    {
                        if ( $prio -eq "2" -or $prio -eq "3" )
                        {
                            $important1 = "<span class=`"important_style`"> {0}" -f $otherTerm["importantMark"]
                            $important2 = "</span>"
                        }
                        else
                        {
                            $important1 = ""
                            $important2 = ""
                        }

                        $PartCsv4 = [array]( $PartCsv3 | where { $_.PRIO -eq $prio } )
                        if ( $PartCsv4 -eq $null -or $PartCsv4.Length -eq 0 )
                        {
                            continue
                        }
                        $PartCsv4 | Foreach-object `
                        {
                            $n ++
                            if ( $ct -eq "0" )
                            {
                                $CategoryStr = $otherTerm["nocomp"]
                                $CategoryClass = "nocomp_style"
                            }
                            else
                            {
                                $CategoryStr = Convert-Category( $ct )
                                $CategoryClass = Convert-CategoryToClass( $ct )
                            }

                            $html_title = ($_.TITLE -replace "@@_COMMA_@@",",")

                            #---- mainファイルのリスト
                            if ( $preVerStr -ne $_.VERSION )
                            {
                                if ( $listIn )
                                {
                                    $IList += "</ul>"
                                }
                                $IList += "<p style=`"line-height:0%;`">{0}</p>" -f $_.VERSION
                                $IList += "<ul>"
                                $preVerStr = $_.VERSION
                                $listIn = $true
                            }

                            $cmark = "<span class=`"release_note`"><span class=`"mini_{0}`"></span></span> " -f $CategoryClass
                            $IList += "<li>{6}<a href=`"#note_{5}`">{3}{0}: ({1}) {2}{4}</a></li>" -f
                                       $_.ID, $Component, $html_title, $important1, $important2, $_.HASH, $cmark

                            $CList +=  ("<h3 id=`"note_{1}`" class=`"release_note`">($n)<span class=`"{3}`"></span> {4}<a href=`"{2}#note_{1}`">{0}</a>: "`
                                   -f $_.ID, $_.HASH,$mainName,$CategoryClass, $important1)`
                                   +  ("({0}) {1}{3}  <a href=`"#{2}`"><font size=`"2`">&lt;</font></a></h3>" -f $Component, $html_title, $hash, $important2)
                            $CList +=  ("<p style=`"line-height:0%;`"><small style=`"line-height:0%;`">{0}</small></p><br>" -f $_.VERSION )
                            $CList +=  ("{0}" -f ($_.CONTENT -replace "@@_COMMA_@@",","))
                        }
                    }
                }
            }
            if ( $listIn )
            {
                $IList += "</ul>"
            }
        }
        break
    }

    [string[]]$private:FList = @() #フッタ用
    Add-FooterPart ([ref]$FList)

    New-Item $name -itemType file -Force | Out-Null
    [string]::join("`r`n", $HList) | Out-File -Encoding UTF8 $name
    if ( $IList -ne $null -and $IList.Length -ne 0 )
    {
        [string]::join("`r`n", $IList) | Out-File -Encoding UTF8 $name -Append
    }
    if ( $CList -ne $null -and $CList.Length -ne 0 )
    {
        [string]::join("`r`n", $CList) | Out-File -Encoding UTF8 $name -Append
    }
    [string]::join("`r`n", $FList) | Out-File -Encoding UTF8 $name -Append
}
