#
#    COMMAND -InFile <files> -OriginalLog <file> [-OutFile <file>] [-IgnoreVersion] [-Detail]
#
#       -InFile <files>               p󂳂ꂽXMLt@C
#       -OriginalLog <name>           p̂ƂƂȂCSVt@C
#                                     xxx \F ȗXML<FileName></FileName>琄
#       -OutFile <name>               o̓t@CB
#                                     xxx ȗ͌t@C̐
#       -IgnoreVersion                o[W`FbNsȂ
#       -Detail                       ̏ڍׂɕ\BȗŁAȗ͏ڍׂ\ȂB
#
#    () COMMAND -InFile .\data_en.dat -OriginalLog .\data.dat -OutFile ..\..\data_en.dat -Detail
#
#         wȂ NW_0_7_0_Ja.ex.xml  NW_0.7.0_En.dat o
#
param
(
    [Parameter(Mandatory=$true)]
    [string]$InFile,

    [string]$OriginalLog = "",
    [String]$OutFile = "",

    [switch]$IgnoreVersion,
    [switch]$Detail
)

#----------------------------------------------------------------
# o[Wr
function Compare-Version( [Xml]$c1, $c2 )
{
    #---- c1 o[WT
    $ver1 = $c1.ReleaseNote.DataVersion

    #---- c2 o[WT
    $ver2 = ""
    foreach ( $line in $c2 )
    {
        if ( $line -match "^#" -and $line -match "DataVersion =[ ]*([0-9]*)" )
        {
           $ver2 = $matches[1]
        }
    }

    if ( $Detail -ne $false )
    {
        Write-Host ("*** Version: {0}, {1}" -f $ver1, $ver2 )
    }

    if ( "" -eq $ver1 -or "" -eq $ver2 -or $ver1 -ne $ver2 )
    {
        return $false
    }
    return $true
}
#----------------------------------------------------------------
# wL[
#
function Search-EngLine( [Xml]$c, $hash )
{
    [array]$items = $c.ReleaseNote.Item
    for( $i=0; $i -lt $items.Length; $i++ )
    {
        if ( $items[$i].Id -eq $hash )
        {
            $conStr = ""
            foreach ( $a in ([array]($items[$i].Content.Line)) )
            {
                $conStr += ($a.InnerText -replace "`"","`"`"" -replace "`\`\","`\`\" -replace "]]&gt;","]]>") + "\r\n"
            }

            $titleStr = $items[$i].Title.Line.InnerText -replace "`"","`"`"" -replace "`\`\","`\`\" -replace "]]&gt;","]]>"

            return  $titleStr, ($conStr -replace "\\r\\n$","")
        }
    }
    return $null, $null
}

#================================================================================
#---- t@Č
# "xxx_nnn_ll.ex.xml" -> xxx_nnn_ll.dat ƍ킹 xxx_nnn_LL.dat o
#  NW_0_4_0_Ja.ex.xml -> NW_0_4_0_Ja.dat ƍ킹 NW_0_4_0_En.dat o
#
#    킹Ă݂t@C -OriginalLog ΂D悵
#   o͐ -OutFile w肪΂D悷

$OrigCandidate = ($InFile -replace ".ex.xml","") + ".dat"
$OutCandidate  = ($InFile -replace "Ja.ex.xml","") + "En.dat"

if ( $OriginalLog -eq "" )
{
    $OriginalLog = $OrigCandidate
}
if ( $OutFile -eq "" )
{
    $OutFile = $OutCandidate
}

if ( $Detail -ne $false )
{
    Write-Host( "*** Original log: {0}" -f $OriginalLog )
    Write-Host( "*** Output file:  {0}" -f $OutFile )
}

#---- ͂ƂȂQ̃t@C
if ( $false -eq (Test-Path $Infile) )
{
    Write-Host ("** Cannot open input file {0}." -f $InFile)
    exit(1)
}
if ( $false -eq (Test-Path $OriginalLog) )
{
    Write-Host ("** Cannot open original log {0}." -f $OriginalLog)
    exit(1)
}

[Xml]$contents1 = Get-Content -Encoding UTF8 $InFile
$contents2 = (Get-Content -Encoding UTF8 $OriginalLog)

#---- o[Wr
if ( $true -ne $IgnoreVersion )
{
    if ( $false -eq (Compare-Version $contents1 $contents2) )
    {
        Write-Host "*** Different version."
        exit(1)
    }
}

#---- o̓t@C
New-Item -force -ItemType file $OutFile | Out-Null

#---- sǂݍł
foreach ( $line in $contents2 )
{
    #---- s͂̂܂
    if ( $line.Trim() -eq "" )
    {
        $line | Out-File -Encoding UTF8 $OutFile -Append
        continue
    }
    #---- Rgs
    if ( $line -match "^#" -or $line.Trim() -eq "" )
    {
        #---- Lang  En ɕς
        if ( $line -match "^# Lang[ ]* = Ja" )
        {
            "# Lang    = En" | Out-File -Encoding UTF8 $OutFile -Append
        }
        else
        {
            $line | Out-File -Encoding UTF8 $OutFile -Append
        }
        continue
    }
    #---- es̕
    $c = $line | ConvertFrom-Csv -Delimiter "," -Header HASH,LANG,KEY,CATEGORY,PRIORITY,PACKAGE,COMPONENT_JA,COMPONENT_EN,COMPONENT_CAT,TITLE,CONTENT,FIXVERSION,DATE

    #---- hash  16̂̂Ώ
    if ( $c.HASH.Length -eq 16 )
    {
        $engTitle, $engContent = Search-EngLine $contents1 $c.HASH

        if ( $null -eq $engTitle -or $null -eq $engContent )
        {
            #̂܂܏o
            '"{0}","{1}","{2}","{3}","{4}","{5}","{6}","{7}","{8}","{9}","{10}","{11}","{12}"' -f
                $c.HASH,$c.LANG,$c.KEY,$c.CATEGORY,$c.PRIORITY,$c.PACKAGE,$c.COMPONENT_JA,$c.COMPONENT_EN,$c.COMPONENT_CAT,$c.TITLE,$c.CONTENT,$c.FIXVERSION,$c.DATE `
                | Out-File -Encoding UTF8 $OutFile -Append

            if ( $true -eq $Detail )
            {
                Write-Host( "** Processing {0} (hash={1}) : No conversion." -f $c.KEY, $c.HASH )
            }
        }
        else
        {
            '"{0}","{1}","{2}","{3}","{4}","{5}","{6}","{7}","{8}","{9}","{10}","{11}","{12}"' -f
                $c.HASH,$c.LANG,$c.KEY,$c.CATEGORY,$c.PRIORITY,$c.PACKAGE,$c.COMPONENT_JA,$c.COMPONENT_EN,$c.COMPONENT_CAT,$engTitle,$engContent,$c.FIXVERSION,$c.DATE `
                | Out-File -Encoding UTF8 $OutFile -Append

            if ( $true -eq $Detail )
            {
                Write-Host( "** Processing {0} (hash={1})" -f $c.KEY, $c.HASH )
            }
        }
    }
}

if ( $True -eq $Detail )
{
    Write-Host( "** Output to {0}" -f $OutFile )
}
