#
#  エイリアス情報の読み込み
#
if ( $AliasFile -ne "" )
{
    if ( Test-Path -path "$AliasFile" )
    {
        [XML]$Tags = Get-Content -Encoding UTF8 $AliasFile
        $IsLoadAliasList = $true
    }
}

function Create-ProjectAliases( [xml]$aliases )
{
    $aliasRule = @{}
    $aliasArray = @()
    if ( $aliases.AliasList.ProjectList.name.GetType().FullName -eq "System.String" )
    {
        $aliasRule.Add( $aliases.AliasList.ProjectList.name, $aliases.AliasList.ProjectList.fname )
        $aliasArray += $aliases.AliasList.ProjectList.name
    }
    else
    {
        for( $i=0; $i -lt $aliases.AliasList.ProjectList.name.Length; $i++ )
        {
            $aliasRule.Add( $aliases.AliasList.ProjectList.name[$i], $aliases.AliasList.ProjectList.fname[$i] )
            $aliasArray += $aliases.AliasList.ProjectList.name[$i]
        }
    }
    return $aliasRule, $aliasArray
}

function Create-PackageAliases( [xml]$aliases )
{
    $aliasRule = @{}
    $fnameRule = @{}
    $aliasRuleArray = @()
    $fnameRuleArray = @()
    if ( $aliases.AliasList.PackageList.name.GetType().FullName -eq "System.String" )
    {
        $aliasRule.Add( $aliases.AliasList.PackageList.alias, $aliases.AliasList.PackageList.name )
        $fnameRule.Add( $aliases.AliasList.PackageList.name,  $aliases.AliasList.PackageList.fname )
        $aliasRuleArray += $aliases.AliasList.PackageList.alias
        $fnameRuleArray += $aliases.AliasList.PackageList.name
    }
    else
    {
        for( $i=0; $i -lt $aliases.AliasList.PackageList.name.Length; $i++ )
        {
            $aliasRule.Add( $aliases.AliasList.PackageList.alias[$i], $aliases.AliasList.PackageList.name[$i] )
            $fnameRule.Add( $aliases.AliasList.PackageList.name[$i],  $aliases.AliasList.PackageList.fname[$i] )
            $aliasRuleArray += $aliases.AliasList.PackageList.alias[$i]
            $fnameRuleArray += $aliases.AliasList.PackageList.name[$i]
        }
    }
    return $aliasRule, $fnameRule, $aliasRuleArray, $fnameRuleArray
}


function Create-VersionAliases( [xml]$aliases )
{
    $aliasRule = @{}
    $fnameRule = @{}
    $aliasRuleArray = @()
    $fnameRuleArray = @()
    if ( $aliases.AliasList.VersionList.name.GetType().FullName -eq "System.String" )
    {
        $aliasRule.Add( $aliases.AliasList.VersionList.alias, $aliases.AliasList.VersionList.name )
        $fnameRule.Add( $aliases.AliasList.VersionList.name,  $aliases.AliasList.VersionList.fname )
        $aliasRuleArray += $aliases.AliasList.VersionList.alias
        $fnameRuleArray += $aliases.AliasList.VersionList.name
    }
    else
    {
        for( $i=0; $i -lt $aliases.AliasList.VersionList.name.Length; $i++ )
        {
            $aliasRule.Add( $aliases.AliasList.VersionList.alias[$i], $aliases.AliasList.VersionList.name[$i] )
            $fnameRule.Add( $aliases.AliasList.VersionList.name[$i],  $aliases.AliasList.VersionList.fname[$i] )
            $aliasRuleArray += $aliases.AliasList.VersionList.alias[$i]
            $fnameRuleArray += $aliases.AliasList.VersionList.name[$i]
        }
    }
    return $aliasRule, $fnameRule, $aliasRuleArray, $fnameRuleArray
}

function Create-IdAliases( [xml]$aliases )
{
    $aliasRule = @{}
    if ( $aliases.AliasList.IdList.name.GetType().FullName -eq "System.String" )
    {
        $aliasRule.Add( $aliases.AliasList.IdList.name, $aliases.AliasList.IdList.idStr )
    }
    else
    {
        for( $i=0; $i -lt $aliases.AliasList.IdList.name.Length; $i++ )
        {
            $aliasRule.Add( $aliases.AliasList.IdList.name[$i], $aliases.AliasList.IdList.idStr[$i] )
        }
    }
    return $aliasRule
}

#---- エイリアス考慮
function Filter-AliasStr( $aliasRule, $a )
{
    if ( $aliasRule.Contains( $a ) )
    {
        return $aliasRule[$a]
    }
    else
    {
        return $a
    }
}
