﻿#
# 変更履歴を収集してみてチェックする
#

#---------------- 定数定義
set-variable -name INDEX_NAME          -value 0 -option constant
set-variable -name INDEX_GATHER_CONFIG -value 1 -option constant
set-variable -name INDEX_OUTPUT_CONFIG -value 2 -option constant
set-variable -name INDEX_OUTPUT_DIR    -value 3 -option constant

set-variable -name INDEX_JA -value 0 -option constant
set-variable -name INDEX_EN -value 1 -option constant

set-variable -name ACTION_NONE   -value "-1" -option constant
set-variable -name ACTION_DISPLAY -value 0 -option constant
set-variable -name ACTION_GATHER -value 1 -option constant
set-variable -name ACTION_OUTPUT -value 2 -option constant

# 言語
$language = $INDEX_JA
$EnglishOption = $(if ( $language -eq $INDEX_JA ){ "" }else{ "-English" } )

# パッケージリスト
$Packages_All = @( "NintendoSDK", "NintendoSDK-Addon", "NintendoSDK-Samples", "NintendoSDK-Samples-Addon", `
                   "NintendoWare", "NintendoWare-Addon", "NintendoWare-Samples", "NintendoWare-Samples-Addon", `
                   "TargetManager", "Thumbnail-Explorer-Extensions", `
                   "ControllerKit", "OceanKit", "UnityKit", "PlayReportKit", `
                   "NetworkMiddlewareKit", "NetworkMiddlewareKit-Addon", "TurboSKit", "AppletKit" )

$Packages_SDK = @( "NintendoSDK", "NintendoSDK-Addon", "NintendoSDK-Samples", "NintendoSDK-Samples-Addon", `
                   "NintendoWare", "NintendoWare-Addon", "NintendoWare-Samples", "NintendoWare-Samples-Addon" )

#--------------------------------------------------------------------------------
function Show-InputUserForm()
{
  # アセンブリのロード
  Add-Type -AssemblyName System.Windows.Forms
  Add-Type -AssemblyName System.Drawing

  # フォームの作成
  $form = New-Object System.Windows.Forms.Form
  $form.Text = "ユーザ名とパスワード入力"
  $form.Size = New-Object System.Drawing.Size(280,260)
  $form.StartPosition = "CenterScreen"

  # OKボタンの設定
  $OKButton = New-Object System.Windows.Forms.Button
  $OKButton.Location = New-Object System.Drawing.Point(50,170)
  $OKButton.Size = New-Object System.Drawing.Size(75,30)
  $OKButton.Text = "OK"
  $OKButton.DialogResult = "OK"

  # キャンセルボタンの設定
  $CancelButton = New-Object System.Windows.Forms.Button
  $CancelButton.Location = New-Object System.Drawing.Point(140,170)
  $CancelButton.Size = New-Object System.Drawing.Size(75,30)
  $CancelButton.Text = "Cancel"
  $CancelButton.DialogResult = "Cancel"

  # ラベルの設定
  $label = New-Object System.Windows.Forms.Label
  $label.Location = New-Object System.Drawing.Point(20,50)
  $label.Size = New-Object System.Drawing.Size(250,20)
  $label.Text = "User"

  $label2 = New-Object System.Windows.Forms.Label
  $label2.Location = New-Object System.Drawing.Point(20,100)
  $label2.Size = New-Object System.Drawing.Size(250,20)
  $label2.Text = "Password"

  $label3 = New-Object System.Windows.Forms.Label
  $label3.Location = New-Object System.Drawing.Point(20,10)
  $label3.Size = New-Object System.Drawing.Size(250,30)
  $label3.Text = "認証ファイルがありません。`r`nJIRA アカウントを入力してください。"

  # 入力ボックスの設定
  $textBox = New-Object System.Windows.Forms.TextBox
  $textBox.Location = New-Object System.Drawing.Point(40,70)
  $textBox.Size = New-Object System.Drawing.Size(185,50)

  $textBox2 = New-Object System.Windows.Forms.TextBox
  $textBox2.Location = New-Object System.Drawing.Point(40,120)
  $textBox2.Size = New-Object System.Drawing.Size(185,50)
  $textBox2.PasswordChar = "*"

  # キーとボタンの関係
  $form.AcceptButton = $OKButton
  $form.CancelButton = $CancelButton

  # ボタン等をフォームに追加
  $form.Controls.Add($OKButton)
  $form.Controls.Add($CancelButton)
  $form.Controls.Add($label)
  $form.Controls.Add($label2)
  $form.Controls.Add($label3)
  $form.Controls.Add($textBox)
  $form.Controls.Add($textBox2)

  # フォームを表示させ、その結果を受け取る
  $result = $form.ShowDialog()

  # 結果による処理分岐
  if ($result -eq "OK")
  {
      # Write-Host $textBox.Text $textBox2.Text
      return $textBox.Text, $textBox2.Text
  }
  else
  {
      return $null, $null
  }
}

#--------------------------------------------------------------------------------
function Show-Dialog( [ref]$text, [ref]$caption, $itype )
{
  Set-StrictMode -version Latest
  Add-Type -AssemblyName System.Windows.Forms;

  $private:buttonsType = "OK"
  $result = [System.Windows.Forms.MessageBox]::Show($text.value, $caption.value, $buttonsType, $itype);
}
#--------------------------------------------------------------------------------
function Show-DialogOkCancel( [ref]$text, [ref]$caption, $itype )
{
  Set-StrictMode -version Latest
  Add-Type -AssemblyName System.Windows.Forms;

  $private:buttonsType = "OKCancel"
  $result = [System.Windows.Forms.MessageBox]::Show($text.value, $caption.value, $buttonsType, $itype);
  return $result
}

#--------------------------------------------------------------------------------
# プロジェクト・パッケージ・バージョン指定で読み込み
#
function Check-EachChangeLog( $pro, $pac, $ver )
{
#    Write-Host $script:pro ":" $script:pac "-" $script:ver
#    Write-Host $pro ":" $pac "-" $ver

    if ( $IsUseAuthFile )
    {
        $args = ( "-AuthenticationFile", $AuthFile, "-AliasFile", $AliasFile, "-ComponentRuleFile", $ComponentRuleFile,
                  "-Project", $pro, "-Version", $ver, "-Package", $pac, "-CheckHtml", $EnglishOption )
        powershell .\gatherChangeLog.ps1 $args
    }
    else
    {
        $args = ( "-User", "$User", "-Password", "'$Password'", "-AliasFile", $AliasFile, "-ComponentRuleFile", $ComponentRuleFile,
                  "-Project", $pro, "-Version", "`"`"$ver`"`"", "-Package", $pac, "-CheckHtml", $EnglishOption )
        powershell .\gatherChangeLog.ps1 $args
    }
}

#================================================================================
#  メイン処理
#
$AliasFile = ".\config\Aliases.xml"
$IsLoadAliasList = $false
. .\loadAliasList.ps1
if ( ! $IsLoadAliasList )
{
    Write-Host "Cannot find alias file."
    exit
}
$projectFnameAliasRule, $projectAliasArray                                             = Create-ProjectAliases $Tags
$packageAliasRule, $packageFnameAliasRule, $packageAliasArray, $packageFnameAliasArray = Create-PackageAliases $Tags
$versionAliasRule, $versionFnameAliasRule, $versionAliasArray, $versionFnameAliasArray = Create-VersionAliases $Tags

# アセンブリのロード
Add-Type -AssemblyName System.Windows.Forms
Add-Type -AssemblyName System.Drawing

# フォーム全体の設定
$form = New-Object System.Windows.Forms.Form 
$form.Text = "選択"
$form.Size = New-Object System.Drawing.Size(580,500)
$form.StartPosition = "CenterScreen"

# ラベルを表示
$label = New-Object System.Windows.Forms.Label
$label.Location = New-Object System.Drawing.Point(10,120)
$label.Size = New-Object System.Drawing.Size(200,20)
$label.Text = "パッケージ"

$label2 = New-Object System.Windows.Forms.Label
$label2.Location = New-Object System.Drawing.Point(300,120)
$label2.Size = New-Object System.Drawing.Size(200,20)
$label2.Text = "バージョン"

$label3 = New-Object System.Windows.Forms.Label
$label3.Location = New-Object System.Drawing.Point(10,10)
$label3.Size = New-Object System.Drawing.Size(200,20)
$label3.Text = "プロジェクト"

$label4 = New-Object System.Windows.Forms.Label
$label4.Location = New-Object System.Drawing.Point(300,10)
$label4.Size = New-Object System.Drawing.Size(200,20)
$label4.Text = ""

# OKボタンの設定
$OKButton = New-Object System.Windows.Forms.Button
$OKButton.Location = New-Object System.Drawing.Point(190,410)
$OKButton.Size = New-Object System.Drawing.Size(75,30)
$OKButton.Text = "OK"
$OKButton.DialogResult = [System.Windows.Forms.DialogResult]::OK

# キャンセルボタンの設定
$CancelButton = New-Object System.Windows.Forms.Button
$CancelButton.Location = New-Object System.Drawing.Point(280,410)
$CancelButton.Size = New-Object System.Drawing.Size(75,30)
$CancelButton.Text = "Cancel"
$CancelButton.DialogResult = [System.Windows.Forms.DialogResult]::Cancel

#----
# リストボックスの設定
$listBox = New-Object System.Windows.Forms.ListBox 
$listBox.Location = New-Object System.Drawing.Point(10,140)
$listBox.Size = New-Object System.Drawing.Size(250,200)
$listBox.Height = 200
$listBox.SelectionMode = "MultiExtended"  # 複数選択 OK

# リストボックスに項目を追加
for( $i=0; $i -lt $Packages_All.Length; $i++)
{
     $p = $Packages_All[$i]
     [void] $listBox.Items.Add( $p )
}

#----
# リストボックスの設定
$listBox2 = New-Object System.Windows.Forms.ListBox
$listBox2.Location = New-Object System.Drawing.Point(290,140)
$listBox2.Size = New-Object System.Drawing.Size(250,200)
$listBox2.Height = 200
$listBox2.SelectionMode = "MultiExtended"  # 複数選択 OK

# リストボックスに項目を追加
for( $i=0; $i -lt $versionAliasArray.Length; $i++)
{
     $p = Filter-AliasStr $versionAliasRule $versionAliasArray[$i]
     [void] $listBox2.Items.Add( $p )
}

#----
# リストボックスの設定
$listBox3 = New-Object System.Windows.Forms.ListBox
$listBox3.Location = New-Object System.Drawing.Point(10,30)
$listBox3.Size = New-Object System.Drawing.Size(250,80)
$listBox3.Height = 80
$listBox3.SelectionMode = "MultiExtended"  # 複数選択 OK

# リストボックスに項目を追加
for( $i=0; $i -lt $projectAliasArray.Length; $i++)
{
     $p = $projectAliasArray[$i]
     [void] $listBox3.Items.Add( $p )
     $listBox3.SetSelected( $i, $true ) # 選択された状態
}

$IsOK = $false

#---- クリアボタン
$ClearPackageCheckButton = new-object System.Windows.Forms.Button
$ClearPackageCheckButton.Location = New-Object System.Drawing.Point(30,350)
$ClearPackageCheckButton.Size = New-Object System.Drawing.Size(135,20)
$ClearPackageCheckButton.Text = "パッケージクリア"
$eventForClearPackageCheckButton = {
    for( $i=0; $i -lt $Packages_All.Length; $i++)
    {
        $listBox.SetSelected( $i, $false )
    }
    [System.Windows.Forms.Form]::Invalidate
}
$ClearPackageCheckButton.add_Click( $eventForClearPackageCheckButton )

$ClearVersionCheckButton = new-object System.Windows.Forms.Button
$ClearVersionCheckButton.Location = New-Object System.Drawing.Point(310,350)
$ClearVersionCheckButton.Size = New-Object System.Drawing.Size(135,20)
$ClearVersionCheckButton.Text = "バージョンクリア"
$eventForClearVersionCheckButton = {
    for( $i=0; $i -lt $versionAliasArray.Length; $i++)
    {
        $listBox2.SetSelected( $i, $false )
    }
    [System.Windows.Forms.Form]::Invalidate
}
$ClearVersionCheckButton.add_Click( $eventForClearVersionCheckButton )

#---- パッケージのおすすめ選択
$RecommentPackButton = new-object System.Windows.Forms.Button
$RecommentPackButton.Location = New-Object System.Drawing.Point(325,58)
$RecommentPackButton.Size = New-Object System.Drawing.Size(135,20)
$RecommentPackButton.Text = "SDK パッケージ"
$eventForRecommentPackButton = {
    for( $i=0; $i -lt $Packages_All.Length; $i++)
    {
        $listBox.SetSelected( $i, $( if ($Packages_SDK.IndexOf( $Packages_All[$i] ) -ge 0){$true}else{$false}) )
    }
    [System.Windows.Forms.Form]::Invalidate
}
$RecommentPackButton.add_Click( $eventForRecommentPackButton )

#---- おすすめ選択
$RecommentAllPackButton = new-object System.Windows.Forms.Button
$RecommentAllPackButton.Location = New-Object System.Drawing.Point(325,88)
$RecommentAllPackButton.Size = New-Object System.Drawing.Size(135,20)
$RecommentAllPackButton.Text = "全パッケージ"
$eventForRecommentAllPackButton = {
    for( $i=0; $i -lt $Packages_All.Length; $i++)
    {
        $listBox.SetSelected( $i, $true )
    }
    [System.Windows.Forms.Form]::Invalidate
}
$RecommentAllPackButton.add_Click( $eventForRecommentAllPackButton )

# フォームにアイテムを追加
$form.Controls.Add($label)
$form.Controls.Add($label2)
$form.Controls.Add($label3)
$form.Controls.Add($label4)
$form.Controls.Add($OKButton)
$form.Controls.Add($CancelButton)
$form.Controls.Add($listBox)
$form.Controls.Add($listBox2)
$form.Controls.Add($listBox3)
$form.Controls.Add($ClearPackageCheckButton)
$form.Controls.Add($ClearVersionCheckButton)
$form.Controls.Add($RecommentPackButton)
$form.Controls.Add($RecommentAllPackButton)

# キーとボタンの関係
$form.AcceptButton = $OKButton
$form.CancelButton = $CancelButton

# フォームを最前面に表示
$form.Topmost = $True

#$eve = {
#$_.cancel = $true
#}
#$form.add_Closing( $eve )

# フォームを表示
$result = $form.ShowDialog()

if ($result -eq "OK")
{
    #   Write-Host $listBox.SelectedItems
    #   Write-Host $listBox2.SelectedItems
    #   Write-Host $listBox3.SelectedItems
}
else
{
    exit
}

#----------------------------------------------------------------
if ( ([array]$listBox.SelectedItems).Length -eq 0 -or
     ([array]$listBox2.SelectedItems).Length -eq 0 -or
     ([array]$listBox3.SelectedItems).Length -eq 0 )
{
    $text = @()
    $text += "不足している情報があります。`r`n"
    $result = Show-Dialog ([ref]$text) ([ref]"エラー") "Error"
    exit
}

#----------------------------------------------------------------
# 認証情報
$AuthFile = ".\config\Authentication.xml"
# コンポーネントルールファイル
$ComponentRuleFile = ".\config\componentRule.json"

#-- 認証情報ファイル確認
if ( ! ( Test-Path -path $AuthFile ) )
{
    $User, $Password = Show-InputUserForm
    if ( $User -eq $null -or $Password -eq $null )
    {
        exit
    }
    if ( $User -eq "" -or $Password -eq "" )
    {
        $text = @()
        $text += "入力が不正なので終了します。`r`n"
        Show-Dialog ([ref]$text) ([ref]"エラー") "Error"
        exit
    }
    $IsUseAuthFile = $false
}
else
{
    $IsUseAuthFile = $true
}

#-- コンポーネントルールファイル確認
if ( ! ( Test-Path -path $ComponentRuleFile ) )
{
    $text = @()
    $text += $ComponentRuleFile + " が存在しません。`r`n"
    Show-Dialog ([ref]$text) ([ref]"エラー") "Error"
    exit
}

#---- 作業フォルダの変更
$CommandDir = Split-Path $script:myInvocation.MyCommand.path -parent
cd $CommandDir

#----------------------------------------------------------------
$PackageList = $listBox.SelectedItems
$ProjectList = $listBox3.SelectedItems
$VersionList = @()
foreach ($i in $listBox2.SelectedIndices)
{
    $VersionList += $versionAliasArray[$i]
}

foreach ( $pro in $ProjectList )
{
    foreach ( $ver in $VersionList )
    {
        foreach ( $pac in $PackageList )
        {
            Check-EachChangeLog $pro $pac $ver
        }
    }
}

#----------------------------------------------------------------
$text = @()
$text += "完了しました。`r`n"
$text += "`r`n"

if ( Test-Path -path ".\Check" )
{
    $text += "チェックhtml フォルダを開きますか？`r`n"
    $result = Show-DialogOkCancel ([ref]$text) ([ref]"完了") "Information"
    if ( $result -eq "Ok" )
    {
        Invoke-Item .\Check
   }
}
else
{
    $result = Show-Dialog ([ref]$text) ([ref]"完了") "Information"
}
